/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sc.hxx"



// INCLUDE ---------------------------------------------------------------
#include "XMLExportSharedData.hxx"
#include "XMLExportIterator.hxx"
#include <tools/debug.hxx>

using namespace com::sun::star;

ScMySharedData::ScMySharedData(const sal_Int32 nTempTableCount) :
	nLastColumns(nTempTableCount, 0),
	nLastRows(nTempTableCount, 0),
	pTableShapes(NULL),
	pDrawPages(NULL),
	pShapesContainer(NULL),
	pDetectiveObjContainer(new ScMyDetectiveObjContainer()),
    pNoteShapes(NULL),
	nTableCount(nTempTableCount)
{
}

ScMySharedData::~ScMySharedData()
{
	if (pShapesContainer)
		delete pShapesContainer;
	if (pTableShapes)
		delete pTableShapes;
	if (pDrawPages)
		delete pDrawPages;
	if (pDetectiveObjContainer)
		delete pDetectiveObjContainer;
    if (pNoteShapes)
        delete pNoteShapes;
}

void ScMySharedData::SetLastColumn(const sal_Int32 nTable, const sal_Int32 nCol)
{
	if(nCol > nLastColumns[nTable]) nLastColumns[nTable] = nCol;
}

sal_Int32 ScMySharedData::GetLastColumn(const sal_Int32 nTable)
{
	return nLastColumns[nTable];
}

void ScMySharedData::SetLastRow(const sal_Int32 nTable, const sal_Int32 nRow)
{
	if(nRow > nLastRows[nTable]) nLastRows[nTable] = nRow;
}

sal_Int32 ScMySharedData::GetLastRow(const sal_Int32 nTable)
{
	return nLastRows[nTable];
}

void ScMySharedData::AddDrawPage(const ScMyDrawPage& aDrawPage, const sal_Int32 nTable)
{
	if (!pDrawPages)
		pDrawPages = new ScMyDrawPages(nTableCount, ScMyDrawPage());
	(*pDrawPages)[nTable] = aDrawPage;
}

void ScMySharedData::SetDrawPageHasForms(const sal_Int32 nTable, sal_Bool bHasForms)
{
	DBG_ASSERT(pDrawPages, "DrawPages not collected");
	if (pDrawPages)
		(*pDrawPages)[nTable].bHasForms = bHasForms;
}

uno::Reference<drawing::XDrawPage> ScMySharedData::GetDrawPage(const sal_Int32 nTable)
{
	DBG_ASSERT(pDrawPages, "DrawPages not collected");
	if (pDrawPages)
		return (*pDrawPages)[nTable].xDrawPage;
	else
		return uno::Reference<drawing::XDrawPage>();
}

sal_Bool ScMySharedData::HasForm(const sal_Int32 nTable, uno::Reference<drawing::XDrawPage>& xDrawPage)
{
	sal_Bool bResult(sal_False);
	if (pDrawPages)
	{
		if ((*pDrawPages)[nTable].bHasForms)
		{
			bResult = sal_True;
			xDrawPage = (*pDrawPages)[nTable].xDrawPage;
		}
	}
	return bResult;
}

void ScMySharedData::AddNewShape(const ScMyShape& aMyShape)
{
	if (!pShapesContainer)
		pShapesContainer = new ScMyShapesContainer();
	pShapesContainer->AddNewShape(aMyShape);
}

void ScMySharedData::SortShapesContainer()
{
	if (pShapesContainer)
		pShapesContainer->Sort();
}

sal_Bool ScMySharedData::HasShapes()
{
	return ((pShapesContainer && pShapesContainer->HasShapes()) ||
			(pTableShapes && !pTableShapes->empty()));
}

void ScMySharedData::AddTableShape(const sal_Int32 nTable, const uno::Reference<drawing::XShape>& xShape)
{
	if (!pTableShapes)
		pTableShapes = new ScMyTableShapes(nTableCount);
	(*pTableShapes)[nTable].push_back(xShape);
}

void ScMySharedData::AddNoteObj(const uno::Reference<drawing::XShape>& xShape, const ScAddress& rPos)
{
    if (!pNoteShapes)
        pNoteShapes = new ScMyNoteShapesContainer();
    ScMyNoteShape aNote;
    aNote.xShape = xShape;
    aNote.aPos = rPos;
    pNoteShapes->AddNewNote(aNote);
}

void ScMySharedData::SortNoteShapes()
{
    if (pNoteShapes)
        pNoteShapes->Sort();
}
