/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



#ifndef SC_XLLINK_HXX
#define SC_XLLINK_HXX

#include <sal/types.h>

// Constants and Enumerations =================================================

const sal_uInt16 EXC_TAB_EXTERNAL           = 0xFFFE;     /// Special sheet index for external links.
const sal_uInt16 EXC_TAB_DELETED            = 0xFFFF;     /// Deleted sheet in a 3D reference.

// (0x0016) EXTERNCOUNT -------------------------------------------------------

const sal_uInt16 EXC_ID_EXTERNCOUNT         = 0x0016;

// (0x0017) EXTERNSHEET -------------------------------------------------------

const sal_uInt16 EXC_ID_EXTERNSHEET         = 0x0017;

const sal_Unicode EXC_EXTSH_URL             = '\x01';
const sal_Unicode EXC_EXTSH_OWNTAB          = '\x02';
const sal_Unicode EXC_EXTSH_TABNAME         = '\x03';
const sal_Unicode EXC_EXTSH_OWNDOC          = '\x04';
const sal_Unicode EXC_EXTSH_ADDIN           = '\x3A';

// (0x0023) EXTERNNAME --------------------------------------------------------

const sal_uInt16 EXC_ID_EXTERNNAME          = 0x0023;

const sal_uInt16 EXC_EXTN_BUILTIN           = 0x0001;
const sal_uInt16 EXC_EXTN_OLE               = 0x0010;
const sal_uInt16 EXC_EXTN_OLE_OR_DDE        = 0xFFFE;

const sal_uInt16 EXC_EXTN_EXPDDE_STDDOC     = 0x7FEA;  /// for export
const sal_uInt16 EXC_EXTN_EXPDDE            = 0x7FE2;  /// for export

// (0x0059, 0x005A) XCT, CRN --------------------------------------------------

const sal_uInt16 EXC_ID_XCT                 = 0x0059;
const sal_uInt16 EXC_ID_CRN                 = 0x005A;

// (0x013D) TABID -------------------------------------------------------------

const sal_uInt16 EXC_ID_TABID               = 0x013D;

// (0x01AE) SUPBOOK -----------------------------------------------------------

const sal_uInt16 EXC_ID_SUPBOOK             = 0x01AE;

const sal_uInt16 EXC_SUPB_SELF              = 0x0401;
const sal_uInt16 EXC_SUPB_ADDIN             = 0x3A01;

/** This enumeration specifies the type of a SUPBOOK record. */
enum XclSupbookType
{
    EXC_SBTYPE_UNKNOWN,     /// unknown SUPBOOK record type.
    EXC_SBTYPE_SELF,        /// SUPBOOK is used for internal references.
    EXC_SBTYPE_EXTERN,      /// SUPBOOK is used for external references.
    EXC_SBTYPE_ADDIN,       /// SUPBOOK contains add-in functions.
    EXC_SBTYPE_SPECIAL,     /// SUPBOOK is used for DDE or OLE links.
    EXC_SBTYPE_EUROTOOL     /// SUPBOOK is uesd for EUROCONVERT.
};

// ============================================================================

#endif

