/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



#ifndef SC_TOOL_H
#define SC_TOOL_H

#include <attrib.hxx>    //!!! noch noetig?????
#include <document.hxx>

// Defaultwerte
const sal_uInt8	nDezStd = 0;		// Dezimalstellen fuer Standard-Zellen
const sal_uInt8	nDezFloat = 2;	//        "         "  Float-Zellen

void		PutFormString( SCCOL nCol, SCROW nRow, SCTAB nTab, sal_Char *pString );

void		SetFormat( SCCOL nCol, SCROW nRow, SCTAB nTab, sal_uInt8 nFormat, sal_uInt8 nSt );

void		InitPage( void );

String		DosToSystem( sal_Char *pSource );

double		SnumToDouble( sal_Int16 nVal );

double          Snum32ToDouble( sal_uInt32 nValue );

typedef sal_uInt16 StampTyp;

#define MAKE_STAMP(nF,nS) ((nS&0x0F)+((nF&0x7F)*16))
			// Bit 0...3  = Bit 0...3 von Stellenzahl
			// Bit 4...10 = Bit 0...6 von Formatbyte

class FormIdent
{
private:
	StampTyp		nStamp;			// Identifikations-Schluessel
	SfxUInt32Item*	pAttr;			// zugehoeriges Attribut
public:
					FormIdent( void )
					{
						nStamp = 0;
						pAttr = NULL;
					}

					FormIdent( sal_uInt8 nFormat, sal_uInt8 nSt, SfxUInt32Item& rAttr )
					{
						nStamp = MAKE_STAMP( nFormat, nSt );
						pAttr = &rAttr;
					}

					FormIdent( sal_uInt8 nFormat, sal_uInt8 nSt )
					{
						nStamp = MAKE_STAMP( nFormat, nSt );
						pAttr = NULL;
					}

	sal_Bool			operator ==( const FormIdent& rComp ) const
					{
						return ( nStamp == rComp.nStamp );
					}

	sal_Bool			operator ==( const StampTyp& rStamp ) const
					{
						return ( nStamp == rStamp );
					}

	StampTyp		GetStamp( void ) const
					{
						return nStamp;
					}

	SfxUInt32Item*	GetAttr( void )
					{
						return pAttr;
					}

	void			SetStamp( sal_uInt8 nFormat, sal_uInt8 nSt )
					{
						nStamp = MAKE_STAMP( nFormat, nSt );
					}
};


#define __nSize 2048




class FormCache
{
private:
	FormIdent			aIdents[ __nSize ];	//gepufferte Formate
	sal_Bool				bValid[ __nSize ];
	FormIdent			aCompareIdent;		// zum Vergleichen
	sal_uInt8				nDefaultFormat;		// Defaultformat der Datei
	SvNumberFormatter*	pFormTable;			// Value-Format-Table-Anker
	StampTyp			nIndex;
	LanguageType		eLanguage;			// Systemsprache

	SfxUInt32Item*		NewAttr( sal_uInt8 nFormat, sal_uInt8 nSt );
public:
						FormCache( ScDocument*, sal_uInt8 nNewDefaultFormat = 0xFF );
						~FormCache();

	inline const SfxUInt32Item*	GetAttr( sal_uInt8 nFormat, sal_uInt8 nSt );
	void				SetDefaultFormat( sal_uInt8 nD = 0xFF )
						{
							nDefaultFormat = nD;
						}
};


inline const SfxUInt32Item* FormCache::GetAttr( sal_uInt8 nFormat, sal_uInt8 nSt )
{
	// PREC:	nFormat = Lotus-Format-Byte
	//			nSt = Stellenzahl
	// POST:	return = zu nFormat und nSt passendes SC-Format
	SfxUInt32Item*		pAttr;
	SfxUInt32Item*		pRet;

	aCompareIdent.SetStamp( nFormat, nSt );
	nIndex = aCompareIdent.GetStamp();
	DBG_ASSERT( nIndex < __nSize, "FormCache::GetAttr(): Uuuuuuups... so nicht!" );
	if( bValid[ nIndex ] )
		pRet = aIdents[ nIndex ].GetAttr();
	else
	{
		// neues Attribut anlegen
		pAttr = NewAttr( nFormat, nSt );
		DBG_ASSERT( pAttr, "FormCache::GetAttr(): Nix Speicherus" );

		aIdents[ nIndex ] = FormIdent( nFormat, nSt, *pAttr );
		bValid[ nIndex ] = sal_True;

		pRet = pAttr;
	}
	return pRet;
}

#endif

