/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sc.hxx"
// INCLUDE ---------------------------------------------------------------



#include "subtotal.hxx"
#include "interpre.hxx"

// -----------------------------------------------------------------------

sal_Bool SubTotal::SafePlus(double& fVal1, double fVal2)
{
	sal_Bool bOk = sal_True;
	SAL_MATH_FPEXCEPTIONS_OFF();
    fVal1 += fVal2;
	if (!::rtl::math::isFinite(fVal1))
	{
		bOk = sal_False;
		if (fVal2 > 0.0)
			fVal1 = DBL_MAX;
		else
			fVal1 = -DBL_MAX;
	}
	return bOk;
}


sal_Bool SubTotal::SafeMult(double& fVal1, double fVal2)
{
	sal_Bool bOk = sal_True;
	SAL_MATH_FPEXCEPTIONS_OFF();
    fVal1 *= fVal2;
	if (!::rtl::math::isFinite(fVal1))
	{
		bOk = sal_False;
		fVal1 = DBL_MAX;
	}
	return bOk;
}


sal_Bool SubTotal::SafeDiv(double& fVal1, double fVal2)
{
	sal_Bool bOk = sal_True;
	SAL_MATH_FPEXCEPTIONS_OFF();
    fVal1 /= fVal2;
	if (!::rtl::math::isFinite(fVal1))
	{
		bOk = sal_False;
		fVal1 = DBL_MAX;
	}
	return bOk;
}
