/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sc.hxx"



#include "refreshtimer.hxx"


ScRefreshTimerProtector::ScRefreshTimerProtector( ScRefreshTimerControl * const * pp )
		:
		ppControl( pp )
{
	if ( ppControl && *ppControl )
	{
		(*ppControl)->SetAllowRefresh( sal_False );
		// wait for any running refresh in another thread to finnish
		::vos::OGuard aGuard( (*ppControl)->GetMutex() );
	}
}


ScRefreshTimer::~ScRefreshTimer()
{
	if ( IsActive() )
		Stop();
	RemoveFromControl();
}


void ScRefreshTimer::SetRefreshDelay( sal_uLong nSeconds )
{
	sal_Bool bActive = IsActive();
	if ( bActive && !nSeconds )
		Stop();
	SetTimeout( nSeconds * 1000 );
	if ( !bActive && nSeconds )
		Start();
}


void ScRefreshTimer::Timeout()
{
	if ( ppControl && *ppControl && (*ppControl)->IsRefreshAllowed() )
	{
		// now we COULD make the call in another thread ...
		::vos::OGuard aGuard( (*ppControl)->GetMutex() );
		maTimeoutHdl.Call( this );
		// restart from now on, don't execute immediately again if timed out
		// a second time during refresh
		if ( IsActive() )
			Start();
	}
}

