/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sc.hxx"



// INCLUDE ---------------------------------------------------------------

#include <tools/debug.hxx>

#include "rechead.hxx"
#include "scerrors.hxx"

// STATIC DATA -----------------------------------------------------------

// =======================================================================

ScMultipleReadHeader::ScMultipleReadHeader(SvStream& rNewStream) :
	rStream( rNewStream )
{
	sal_uInt32 nDataSize;
	rStream >> nDataSize;
	sal_uLong nDataPos = rStream.Tell();
	nTotalEnd = nDataPos + nDataSize;
	nEntryEnd = nTotalEnd;

	rStream.SeekRel(nDataSize);
	sal_uInt16 nID;
	rStream >> nID;
	if (nID != SCID_SIZES)
	{
		DBG_ERROR("SCID_SIZES nicht gefunden");
		if ( rStream.GetError() == SVSTREAM_OK )
			rStream.SetError( SVSTREAM_FILEFORMAT_ERROR );

		//	alles auf 0, damit BytesLeft() wenigstens abbricht
		pBuf = NULL; pMemStream = NULL;
		nEntryEnd = nDataPos;
	}
	else
	{
		sal_uInt32 nSizeTableLen;
		rStream >> nSizeTableLen;
		pBuf = new sal_uInt8[nSizeTableLen];
		rStream.Read( pBuf, nSizeTableLen );
		pMemStream = new SvMemoryStream( (char*)pBuf, nSizeTableLen, STREAM_READ );
	}

	nEndPos = rStream.Tell();
	rStream.Seek( nDataPos );
}

ScMultipleReadHeader::~ScMultipleReadHeader()
{
	if ( pMemStream && pMemStream->Tell() != pMemStream->GetEndOfData() )
	{
		DBG_ERRORFILE( "Sizes nicht vollstaendig gelesen" );
		if ( rStream.GetError() == SVSTREAM_OK )
			rStream.SetError( SCWARN_IMPORT_INFOLOST );
	}
	delete pMemStream;
	delete[] pBuf;

	rStream.Seek(nEndPos);
}

void ScMultipleReadHeader::EndEntry()
{
	sal_uLong nPos = rStream.Tell();
	DBG_ASSERT( nPos <= nEntryEnd, "zuviel gelesen" );
	if ( nPos != nEntryEnd )
	{
		if ( rStream.GetError() == SVSTREAM_OK )
			rStream.SetError( SCWARN_IMPORT_INFOLOST );
		rStream.Seek( nEntryEnd );			// Rest ueberspringen
	}

	nEntryEnd = nTotalEnd;			// den ganzen Rest, wenn kein StartEntry kommt
}

void ScMultipleReadHeader::StartEntry()
{
	sal_uLong nPos = rStream.Tell();
	sal_uInt32 nEntrySize;
	(*pMemStream) >> nEntrySize;

	nEntryEnd = nPos + nEntrySize;
	DBG_ASSERT( nEntryEnd <= nTotalEnd, "zuviele Eintraege gelesen" );
}

sal_uLong ScMultipleReadHeader::BytesLeft() const
{
	sal_uLong nReadEnd = rStream.Tell();
	if (nReadEnd <= nEntryEnd)
		return nEntryEnd-nReadEnd;

	DBG_ERROR("Fehler bei ScMultipleReadHeader::BytesLeft");
	return 0;
}

// -----------------------------------------------------------------------

ScMultipleWriteHeader::ScMultipleWriteHeader(SvStream& rNewStream, sal_uInt32 nDefault) :
	rStream( rNewStream ),
	aMemStream( 4096, 4096 )
{
	nDataSize = nDefault;
	rStream << nDataSize;

	nDataPos = rStream.Tell();
	nEntryStart = nDataPos;
}

ScMultipleWriteHeader::~ScMultipleWriteHeader()
{
	sal_uLong nDataEnd = rStream.Tell();

	rStream << (sal_uInt16) SCID_SIZES;
	rStream << static_cast<sal_uInt32>(aMemStream.Tell());
	rStream.Write( aMemStream.GetData(), aMemStream.Tell() );

	if ( nDataEnd - nDataPos != nDataSize )					// Default getroffen?
	{
		nDataSize = nDataEnd - nDataPos;
		sal_uLong nPos = rStream.Tell();
		rStream.Seek(nDataPos-sizeof(sal_uInt32));
		rStream << nDataSize;								// Groesse am Anfang eintragen
		rStream.Seek(nPos);
	}
}

void ScMultipleWriteHeader::EndEntry()
{
	sal_uLong nPos = rStream.Tell();
	aMemStream << static_cast<sal_uInt32>(nPos - nEntryStart);
}

void ScMultipleWriteHeader::StartEntry()
{
	sal_uLong nPos = rStream.Tell();
	nEntryStart = nPos;
}





