/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sc.hxx"



#include <com/sun/star/uno/Any.hxx>
#include <com/sun/star/uno/Sequence.hxx>

#include "printopt.hxx"
#include "miscuno.hxx"

using namespace utl;
using namespace rtl;
using namespace com::sun::star::uno;

// -----------------------------------------------------------------------

TYPEINIT1(ScTpPrintItem, SfxPoolItem);

// -----------------------------------------------------------------------

ScPrintOptions::ScPrintOptions()
{
	SetDefaults();
}

ScPrintOptions::ScPrintOptions( const ScPrintOptions& rCpy ) :
	bSkipEmpty( rCpy.bSkipEmpty ),
	bAllSheets( rCpy.bAllSheets )
{
}

ScPrintOptions::~ScPrintOptions()
{
}

void ScPrintOptions::SetDefaults()
{
	bSkipEmpty = sal_True;
	bAllSheets = sal_False;
}

const ScPrintOptions& ScPrintOptions::operator=( const ScPrintOptions& rCpy )
{
	bSkipEmpty = rCpy.bSkipEmpty;
	bAllSheets = rCpy.bAllSheets;
	return *this;
}

int ScPrintOptions::operator==( const ScPrintOptions& rOpt ) const
{
	return bSkipEmpty == rOpt.bSkipEmpty
		&& bAllSheets == rOpt.bAllSheets;
}

int ScPrintOptions::operator!=( const ScPrintOptions& rOpt ) const
{
	return !(operator==(rOpt));
}

// -----------------------------------------------------------------------

//UNUSED2008-05  ScTpPrintItem::ScTpPrintItem( sal_uInt16 nWhichP ) : SfxPoolItem( nWhichP )
//UNUSED2008-05  {
//UNUSED2008-05  }

ScTpPrintItem::ScTpPrintItem( sal_uInt16 nWhichP, const ScPrintOptions& rOpt ) :
    SfxPoolItem ( nWhichP ),
	theOptions	( rOpt )
{
}

ScTpPrintItem::ScTpPrintItem( const ScTpPrintItem& rItem ) :
	SfxPoolItem	( rItem ),
	theOptions	( rItem.theOptions )
{
}

ScTpPrintItem::~ScTpPrintItem()
{
}

String ScTpPrintItem::GetValueText() const
{
	return String::CreateFromAscii( "ScTpPrintItem" );
}

int ScTpPrintItem::operator==( const SfxPoolItem& rItem ) const
{
	DBG_ASSERT( SfxPoolItem::operator==( rItem ), "unequal Which or Type" );

	const ScTpPrintItem& rPItem = (const ScTpPrintItem&)rItem;
	return ( theOptions == rPItem.theOptions );
}

SfxPoolItem* ScTpPrintItem::Clone( SfxItemPool * ) const
{
	return new ScTpPrintItem( *this );
}

// -----------------------------------------------------------------------

#define CFGPATH_PRINT			"Office.Calc/Print"

#define SCPRINTOPT_EMPTYPAGES		0
#define SCPRINTOPT_ALLSHEETS		1
#define SCPRINTOPT_COUNT			2

Sequence<OUString> ScPrintCfg::GetPropertyNames()
{
	static const char* aPropNames[] =
	{
		"Page/EmptyPages",			// SCPRINTOPT_EMPTYPAGES
		"Other/AllSheets"			// SCPRINTOPT_ALLSHEETS
	};
	Sequence<OUString> aNames(SCPRINTOPT_COUNT);
	OUString* pNames = aNames.getArray();
	for(int i = 0; i < SCPRINTOPT_COUNT; i++)
		pNames[i] = OUString::createFromAscii(aPropNames[i]);

	return aNames;
}

ScPrintCfg::ScPrintCfg() :
	ConfigItem( OUString::createFromAscii( CFGPATH_PRINT ) )
{
	Sequence<OUString> aNames = GetPropertyNames();
	Sequence<Any> aValues = GetProperties(aNames);
//	EnableNotification(aNames);
	const Any* pValues = aValues.getConstArray();
	DBG_ASSERT(aValues.getLength() == aNames.getLength(), "GetProperties failed");
	if(aValues.getLength() == aNames.getLength())
	{
		for(int nProp = 0; nProp < aNames.getLength(); nProp++)
		{
			DBG_ASSERT(pValues[nProp].hasValue(), "property value missing");
			if(pValues[nProp].hasValue())
			{
				switch(nProp)
				{
					case SCPRINTOPT_EMPTYPAGES:
						// reversed
						SetSkipEmpty( !ScUnoHelpFunctions::GetBoolFromAny( pValues[nProp] ) );
						break;
					case SCPRINTOPT_ALLSHEETS:
						SetAllSheets( ScUnoHelpFunctions::GetBoolFromAny( pValues[nProp] ) );
						break;
				}
			}
		}
	}
}


void ScPrintCfg::Commit()
{
	Sequence<OUString> aNames = GetPropertyNames();
	Sequence<Any> aValues(aNames.getLength());
	Any* pValues = aValues.getArray();

	for(int nProp = 0; nProp < aNames.getLength(); nProp++)
	{
		switch(nProp)
		{
			case SCPRINTOPT_EMPTYPAGES:
				// reversed
				ScUnoHelpFunctions::SetBoolInAny( pValues[nProp], !GetSkipEmpty() );
				break;
			case SCPRINTOPT_ALLSHEETS:
				ScUnoHelpFunctions::SetBoolInAny( pValues[nProp], GetAllSheets() );
				break;
		}
	}
	PutProperties(aNames, aValues);
}

void ScPrintCfg::SetOptions( const ScPrintOptions& rNew )
{
	*(ScPrintOptions*)this = rNew;
	SetModified();
}

void ScPrintCfg::Notify( const ::com::sun::star::uno::Sequence< rtl::OUString >& ) {}

