/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sc.hxx"



#include <unotools/textsearch.hxx>

#include "chgviset.hxx"
#include "rechead.hxx"
#include "chgtrack.hxx"

// -----------------------------------------------------------------------
ScChangeViewSettings::~ScChangeViewSettings()
{
	if(pCommentSearcher!=NULL)
		delete pCommentSearcher;
}

ScChangeViewSettings::ScChangeViewSettings( const ScChangeViewSettings& r )
{
	SetTheComment(r.aComment);

	aFirstDateTime	=r.aFirstDateTime;
	aLastDateTime	=r.aLastDateTime;
	aAuthorToShow	=r.aAuthorToShow;
	aRangeList		=r.aRangeList;
	eDateMode		=r.eDateMode;
	bShowIt			=r.bShowIt;
	bIsDate			=r.bIsDate;
	bIsAuthor		=r.bIsAuthor;
	bIsComment		=r.bIsComment;
	bIsRange		=r.bIsRange;
	bEveryoneButMe	=r.bEveryoneButMe;
	bShowAccepted	=r.bShowAccepted;
	bShowRejected	=r.bShowRejected;
    mbIsActionRange = r.mbIsActionRange;
    mnFirstAction   = r.mnFirstAction;
    mnLastAction    = r.mnLastAction;

}

ScChangeViewSettings& ScChangeViewSettings::operator=( const ScChangeViewSettings& r )
{
	SetTheComment(r.aComment);

	aFirstDateTime	=r.aFirstDateTime;
	aLastDateTime	=r.aLastDateTime;
	aAuthorToShow	=r.aAuthorToShow;
	aRangeList		=r.aRangeList;
	eDateMode		=r.eDateMode;
	bShowIt			=r.bShowIt;
	bIsDate			=r.bIsDate;
	bIsAuthor		=r.bIsAuthor;
	bIsComment		=r.bIsComment;
	bIsRange		=r.bIsRange;
	bEveryoneButMe	=r.bEveryoneButMe;
	bShowAccepted	=r.bShowAccepted;
	bShowRejected	=r.bShowRejected;
    mbIsActionRange = r.mbIsActionRange;
    mnFirstAction   = r.mnFirstAction;
    mnLastAction    = r.mnLastAction;

	return *this;
}

sal_Bool ScChangeViewSettings::IsValidComment(const String* pCommentStr) const
{
	sal_Bool nTheFlag=sal_True;

	if(pCommentSearcher!=NULL)
	{
		xub_StrLen nStartPos = 0;
		xub_StrLen nEndPos = pCommentStr->Len();

        nTheFlag=sal::static_int_cast<sal_Bool>(pCommentSearcher->SearchFrwrd( *pCommentStr, &nStartPos, &nEndPos));
	}
	return nTheFlag;
}

void ScChangeViewSettings::SetTheComment(const String& rString)
{
	aComment=rString;
	if(pCommentSearcher!=NULL)
	{
		delete pCommentSearcher;
		pCommentSearcher=NULL;
	}

	if(rString.Len()>0)
	{
		utl::SearchParam aSearchParam( rString,
			utl::SearchParam::SRCH_REGEXP,sal_False,sal_False,sal_False );

		pCommentSearcher = new utl::TextSearch( aSearchParam, *ScGlobal::pCharClass );
	}
}

void ScChangeViewSettings::AdjustDateMode( const ScDocument& rDoc )
{
    switch ( eDateMode )
    {	// corresponds with ScViewUtil::IsActionShown
        case SCDM_DATE_EQUAL :
        case SCDM_DATE_NOTEQUAL :
            aFirstDateTime.SetTime( 0 );
            aLastDateTime = aFirstDateTime;
            aLastDateTime.SetTime( 23595999 );
            break;
        case SCDM_DATE_SAVE:
        {
            const ScChangeAction* pLast = 0;
            ScChangeTrack* pTrack = rDoc.GetChangeTrack();
            if ( pTrack )
            {
                pLast = pTrack->GetLastSaved();
                if ( pLast )
                {
                    aFirstDateTime = pLast->GetDateTime();
#if 0
// This would be the proper handling. But since the SvxTPFilter dialog uses
// DateField/TimeField, and the filter dialog is used in ScAcceptChgDlg as the
// controlling instance, and the TimeFields are used there without seconds or
// 100ths, we'd display some extra entries between the floor of the minute and
// the start of the next minute.
                    // add one 100th second to point past last saved
                    aFirstDateTime += Time( 0, 0, 0, 1 );
#else
                    // Set the next minute as the start time and assume that
                    // the document isn't saved, reloaded, edited and filter set
                    // all together during the gap between those two times.
                    aFirstDateTime += Time( 0, 1 );
                    aFirstDateTime.SetSec(0);
                    aFirstDateTime.Set100Sec(0);
#endif
                }
            }
            if ( !pLast )
            {
                aFirstDateTime.SetDate( 18990101 );
                aFirstDateTime.SetTime( 0 );
            }
            aLastDateTime = Date();
            aLastDateTime.SetYear( aLastDateTime.GetYear() + 100 );
        }
        break;
        default:
        {
            // added to avoid warnings
        }
    }
}

