/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



//------------------------------------------------------------------------
//------------------------------------------------------------------------

#ifndef _OSL_SOCKET_CONST_H_
#define _OSL_SOCKET_CONST_H_

//------------------------------------------------------------------------
//------------------------------------------------------------------------
#include <sal/types.h>
#include <rtl/textenc.h>
#include <rtl/ustring.hxx>
#include <rtl/ustring.h>

#ifndef _OSL_SOCLET_HXX_
#include <osl/socket.hxx>
#endif
#include <osl/socket.h>

#ifndef _OSL_THREAD_HXX
#include <osl/thread.hxx>
#endif

#ifndef _OSL_FILE_HXX
#include <osl/file.hxx>
#endif

#ifndef _OSL_MUTEX_HXX
#include <osl/mutex.hxx>
#endif
#include <osl/time.h>

const char * pTestString1 = "test socket";
const char * pTestString2 = " Passed#OK";
//define read count 
//------------------------------------------------------------------------
//------------------------------------------------------------------------

#ifdef __cplusplus
extern "C"
{
#endif

#	include <stdio.h> 
//------------------------------------------------------------------------
// OS dependent declaration and includes
//------------------------------------------------------------------------
#if ( defined UNX ) || ( defined OS2 )  //Unix
#	include <unistd.h>
#	include <limits.h>
#	include <string.h>
#	include <math.h>
#	include <errno.h>
#	include <fcntl.h>
#	include <sys/stat.h>
#	include <sys/statfs.h>
#	include <sys/statvfs.h>
#	include <sys/types.h>
#	include <sys/socket.h>
#	include <netdb.h>
#	include <netinet/in.h>           
#       include <arpa/inet.h>
#endif
#if ( defined WNT )                     // Windows
#include <tools/prewin.h>
// #	include <windows.h> 
#	include <winsock.h> 
#	include <string.h>
#include <tools/postwin.h>
#endif


//------------------------------------------------------------------------
// macro definition for the ASCII array/OUString declarations, 
// we use p### for the ASCII array, 
//        a### for the OUString, 
//        n###Len for its length
//------------------------------------------------------------------------

#define OSLTEST_DECLARE( str_name, str_value ) \
	static const sal_Char  p##str_name[]        = str_value;  \
	static const sal_Int32 n##str_name##Len     = sizeof( p##str_name ) -1; \
	::rtl::OUString a##str_name                 = rtl::OUString::createFromAscii( p##str_name )


//------------------------------------------------------------------------
// Ip version definition
//------------------------------------------------------------------------
#define IP_VER     4                   /// currently only IPv4 is considered.

//------------------------------------------------------------------------
// Ip port definition
//------------------------------------------------------------------------
// #define IP_PORT_ZERO    0
// #define IP_PORT_TELNET 23
// #define IP_PORT_SMTP 25
// #define IP_PORT_GOPHER 70
// #define IP_PORT_POP3  110
// #define IP_PORT_NETBIOS_DGM  138
// #define IP_PORT_NETBIOS  139
// #define IP_PORT_IMAP  143
// #define IP_PORT_HTTPS  443
// /**reference: http://www.iana.org/assignments/port-numbers */
// #define IP_PORT_MYPORT  8881 	//8888
// #define IP_PORT_MYPORT1  8882	//8889
// #define IP_PORT_MYPORT3  8884	//8891
// #define IP_PORT_MYPORT4  8885	//8892
// #define IP_PORT_MYPORT5  8886	//8893
// #define IP_PORT_MYPORT6  8887	//8894
// #define IP_PORT_MYPORT7  8895
// #define IP_PORT_MYPORT8  8896
// #define IP_PORT_MYPORT9  8897
// #define IP_PORT_MYPORT10  8898
// 
// #define IP_PORT_TMP    9999
// #define IP_PORT_INVAL  99999

//------------------------------------------------------------------------
// service definitions.
//------------------------------------------------------------------------
// OSLTEST_DECLARE( ServiceFTP,  "ftp" );
// OSLTEST_DECLARE( ServiceTELNET,  "telnet" );
// OSLTEST_DECLARE( ServiceGOPHER,  "gopher" );
// OSLTEST_DECLARE( ServiceIMAP,  "imap" );
// OSLTEST_DECLARE( ServiceHTTPS,  "https" );
// OSLTEST_DECLARE( ServiceNETBIOS,  "netbios-dgm" );

//------------------------------------------------------------------------
// protocol definitions.
//------------------------------------------------------------------------
// OSLTEST_DECLARE( ProtocolTCP,  "tcp" );
// OSLTEST_DECLARE( ProtocolUDP,  "udp" );

//------------------------------------------------------------------------
// Hostnames.
//------------------------------------------------------------------------
// OSLTEST_DECLARE( HostName1,  "localhost" );
// OSLTEST_DECLARE( HostIp1,  "127.0.0.1" );
OSLTEST_DECLARE( HostName2,  "longshot.prc.sun.com" );
OSLTEST_DECLARE( HostIp2,  "129.158.217.202" );
OSLTEST_DECLARE( HostName3,  "deuce.prc.sun.com" );
OSLTEST_DECLARE( HostIp3,  "129.158.217.199" );
OSLTEST_DECLARE( HostName4,  "sceri.PRC.Sun.COM" );  //Beijing server for test
OSLTEST_DECLARE( HostIp4,  "129.158.217.107" );
OSLTEST_DECLARE( HostName5,  "koori.SFBay.Sun.COM" );  //"grande.Germany.Sun.COM" );  //Germany server for test
OSLTEST_DECLARE( HostIp5,  "10.5.32.20" );
OSLTEST_DECLARE( HostName6,  "crumple.SFBay.Sun.COM" );  //sfbay
OSLTEST_DECLARE( HostIp6,  "10.6.103.83" );
OSLTEST_DECLARE( HostIpInval,  "123.45.67.89" );	//this is valid ip number,but can not arrive --mindy
// OSLTEST_DECLARE( HostIpInval1,  "123.345.67.89" );	//this is real invalid ip number --mindy
OSLTEST_DECLARE( HostNameInval,  "www.the_hostname_that_can_not_resolvable_to_an_IP_Address.com" );
OSLTEST_DECLARE( HostIpZero,  "0.0.0.0" );

//------------------------------------------------------------------------
// OS independent file definition
//------------------------------------------------------------------------
OSLTEST_DECLARE( NullURL,  "" );

//------------------------------------------------------------------------
//------------------------------------------------------------------------

#ifdef __cplusplus
}
#endif

//------------------------------------------------------------------------
//------------------------------------------------------------------------


#endif /* _OSL_SOCKET_CONST_H_ */
