/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/


#ifndef RPTUI_DATETIME_HXX
#define RPTUI_DATETIME_HXX

#ifndef _DIALOG_HXX //autogen
#include <vcl/dialog.hxx>
#endif
#ifndef _FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif
#include <vcl/lstbox.hxx>
#include <vcl/field.hxx>
#ifndef _SV_BUTTON_HXX
#include <vcl/button.hxx>
#endif
#include <com/sun/star/report/XReportDefinition.hpp>
#include <com/sun/star/util/XNumberFormats.hpp>
#include <com/sun/star/lang/Locale.hpp>

#include <svtools/dialogcontrolling.hxx>

namespace rptui
{
class OReportController;
/*************************************************************************
|*
|* Groups and Sorting dialog
|*
\************************************************************************/
class ODateTimeDialog :	public ModalDialog
{
	// FixedLine							m_aFLDate;
	CheckBox								m_aDate;
    FixedText                               m_aFTDateFormat;
    ListBox                                 m_aDateListBox;
	FixedLine								m_aFL0;
	CheckBox								m_aTime;
    FixedText                               m_aFTTimeFormat;
    ListBox                                 m_aTimeListBox;
	FixedLine								m_aFL1;
	OKButton								m_aPB_OK;
	CancelButton							m_aPB_CANCEL;
	HelpButton								m_aPB_Help;


	svt::ControlDependencyManager           m_aDateControlling;
	svt::ControlDependencyManager           m_aTimeControlling;

	::rptui::OReportController*				m_pController;
	::com::sun::star::uno::Reference< ::com::sun::star::report::XSection>			
											m_xHoldAlive;
	::com::sun::star::lang::Locale			m_nLocale;

    /** returns the frmat string
    *
    * \param _nNumberFormatKey the number format key
    * \param _xFormats 
    * \param _bTime 
    * \return 
    */
    ::rtl::OUString getFormatStringByKey(::sal_Int32 _nNumberFormatKey,const ::com::sun::star::uno::Reference< ::com::sun::star::util::XNumberFormats>& _xFormats,bool _bTime);

	/** returns the number format key
		@param	_nNumberFormatIndex the number format index @see com::sun::star::i18n::NumberFormatIndex
	*/
	sal_Int32 getFormatKey(sal_Bool _bDate) const;

	DECL_LINK( CBClickHdl, CheckBox* );
    ODateTimeDialog(const ODateTimeDialog&);
    void operator =(const ODateTimeDialog&);

    // fill methods
    void InsertEntry(sal_Int16 _nNumberFormatId);
public:
	ODateTimeDialog( Window* pParent
						,const ::com::sun::star::uno::Reference< ::com::sun::star::report::XSection>& _xHoldAlive
						,::rptui::OReportController* _pController);
	virtual ~ODateTimeDialog();
	virtual short	Execute();
};
// =============================================================================
} // namespace rptui
// =============================================================================
#endif // RPTUI_DATETIME_HXX
