/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/




#ifndef REG_DIAGNOSE_H
#define REG_DIAGNOSE_H

#include <osl/diagnose.h>

#define REG_ENSURE(c, m)   _REG_ENSURE(c, OSL_THIS_FILE, __LINE__, m)

#define _REG_ENSURE(c, f, l, m) \
	do \
	{  \
	    if (!(c) && _OSL_GLOBAL osl_assertFailedLine(f, l, m)) \
		    _OSL_GLOBAL osl_breakDebug(); \
	} while (0)


#endif // REG_DIAGNOSE_H
