/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



#ifndef _CODEMAKER_OPTIONS_HXX_
#define _CODEMAKER_OPTIONS_HXX_

#include	<hash_map>
#include	<codemaker/global.hxx>

#if defined( _MSC_VER ) && ( _MSC_VER < 1200 )
typedef	::std::__hash_map__
<	
	::rtl::OString, 
	::rtl::OString, 
	HashString, 
	EqualString, 
	NewAlloc
> OptionMap;
#else
typedef	::std::hash_map
<	
	::rtl::OString, 
	::rtl::OString, 
	HashString, 
	EqualString
> OptionMap;
#endif

class CannotDumpException
{
public:
	CannotDumpException(const ::rtl::OString& msg)
		: m_message(msg) {}

	::rtl::OString	m_message;	
};


class IllegalArgument
{
public:
	IllegalArgument(const ::rtl::OString& msg)
		: m_message(msg) {}

	::rtl::OString	m_message;	
};


class Options
{
public:
	Options();
	virtual ~Options();

	virtual sal_Bool initOptions(int ac, char* av[], sal_Bool bCmdFile=sal_False) 
		throw( IllegalArgument ) = 0;

	virtual ::rtl::OString	prepareHelp() = 0;

	const ::rtl::OString&	getProgramName() const;
	sal_Bool				isValid(const ::rtl::OString& option);
	const ::rtl::OString	getOption(const ::rtl::OString& option)
		throw( IllegalArgument );

	const StringVector& getInputFiles();

protected:
	::rtl::OString 	m_program;
	StringVector	m_inputFiles;
	OptionMap		m_options;
};
	
#endif // _CODEMAKER_OPTIONS_HXX_

