/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



package mod._namingservice;

import java.io.PrintWriter;

import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.XInterface;

/**
* Test for object which is represented by service
* <code>com.sun.star.uno.NamingService</code>. <p>
* Object implements the following interfaces :
* <ul>
*  <li> <code>com::sun::star::uno::XNamingService</code></li>
* </ul>
* This object test <b> is NOT </b> designed to be run in several
* threads concurently.
* @see com.sun.star.uno.XNamingService
* @see com.sun.star.uno.NamingService
* @see ifc.uno._XNamingService
*/
public class NamingService extends TestCase {

    /**
    * Creating a Testenvironment for the interfaces to be tested.
    * Creates an instance of the service
    * <code>com.sun.star.uno.NamingService</code>.
    *     Object relations created :
    * <ul>
    *  <li> <code>'XNamingService.RegisterObject'</code> for
    *      {@link ifc.uno._XNamingService} : an object
    *      which can be registered. Here it is an instance
    *      of <code>com.sun.star.lang.ServiceManager</code>
    *      service.</li>
    * </ul>
    */
    public TestEnvironment createTestEnvironment( TestParameters Param,
                                                  PrintWriter log )
                                                    throws StatusException {
        XInterface oObj = null;
        Object oInterface = null;

        try {
            XMultiServiceFactory xMSF = (XMultiServiceFactory)Param.getMSF();
            oInterface = xMSF.createInstance
                ( "com.sun.star.uno.NamingService" );
        }
        catch( com.sun.star.uno.Exception e ) {
            log.println("Service not available" );
        }

        oObj = (XInterface) oInterface;

        log.println( "    creating a new environment for object" );
        TestEnvironment tEnv = new TestEnvironment( oObj );

        // objRelation for XNamingService as object to be registered
        try {
            tEnv.addObjRelation("XNamingService.RegisterObject",
                ((XMultiServiceFactory)Param.getMSF()).createInstance
                ("com.sun.star.lang.ServiceManager")) ;
        } catch (com.sun.star.uno.Exception e) {
            log.println("Can't create object relation") ;
            throw new StatusException("Can't create object relation", e) ;
        }

        return tEnv;
    } // finish method getTestEnvironment

}

