/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



package mod._configmgr;

import com.sun.star.beans.NamedValue;
import com.sun.star.uno.XComponentContext;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import java.io.PrintWriter;

public final class ConfigurationProvider extends TestCase {
    public ConfigurationProvider() {}

    protected TestEnvironment createTestEnvironment(
        TestParameters tParam, PrintWriter log)
    {
        // Create a non-default ConfigurationProvider instance, so that testing
        // its XComponent.dispose does not accidentally dispose the
        // DefaultProvider:
        XComponentContext ctxt = tParam.getComponentContext();
        try {
            return ProviderTestEnvironment.create(
                ctxt.getServiceManager().createInstanceWithArgumentsAndContext(
                    "com.sun.star.configuration.ConfigurationProvider",
                    new Object[] { new NamedValue("Locale", "*") },
                    ctxt));
        } catch (com.sun.star.uno.Exception e) {
            throw new RuntimeException(e);
        }
    }
}
