/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



package ifc.sheet;

import lib.MultiPropertyTest;

/**
* Testing <code>com.sun.star.sheet.Spreadsheet</code>
* service properties :
* <ul>
*  <li><code> IsVisible</code></li>
*  <li><code> PageStyle</code></li>
* </ul> <p>
* Properties testing is automated by <code>lib.MultiPropertyTest</code>.
* @see com.sun.star.sheet.Spreadsheet
*/
public class _Spreadsheet extends MultiPropertyTest {

    /**
     *This class is destined to custom test of property <code>PageStyle</code>.
     */
    protected PropertyTester styleTester = new PropertyTester() {
        protected Object getNewValue(String propName, Object oldValue) {
            String str = "Default";
            String str2= "Report";
            return str.equals(oldValue) ? str2 : str;
        }
    };

    /**
     * Test property <code>PageStyle</code> using custom <code>PropertyTest</code>.
     */
    public void _PageStyle() {
        testProperty("PageStyle", styleTester);
    }
} // finish class _Spreadsheet


