/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



#include <com/sun/star/xml/sax/FastToken.hpp>
#include <com/sun/star/beans/XMultiPropertySet.hpp>
#include <com/sun/star/container/XNamed.hpp>

#include "oox/helper/attributelist.hxx"
#include "oox/drawingml/shapegroupcontext.hxx"
#include "oox/drawingml/connectorshapecontext.hxx"
#include "oox/drawingml/graphicshapecontext.hxx"
#include "oox/drawingml/lineproperties.hxx"
#include "oox/drawingml/drawingmltypes.hxx"
#include "oox/drawingml/customshapegeometry.hxx"
#include "oox/drawingml/textbodycontext.hxx"

using rtl::OUString;
using namespace oox::core;
using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::drawing;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::text;
using namespace ::com::sun::star::xml::sax;

namespace oox { namespace drawingml {

ShapeGroupContext::ShapeGroupContext( ContextHandler& rParent, ShapePtr pMasterShapePtr, ShapePtr pGroupShapePtr )
: ContextHandler( rParent )
, mpGroupShapePtr( pGroupShapePtr )
, mpMasterShapePtr( pMasterShapePtr )
{
}

ShapeGroupContext::~ShapeGroupContext()
{
	if ( mpMasterShapePtr.get() && mpGroupShapePtr.get() )
		mpMasterShapePtr->addChild( mpGroupShapePtr );
}

Reference< XFastContextHandler > ShapeGroupContext::createFastChildContext( sal_Int32 aElementToken, const Reference< XFastAttributeList >& xAttribs ) throw (SAXException, RuntimeException)
{
	Reference< XFastContextHandler > xRet;

    switch( getBaseToken( aElementToken ) )
	{
	case XML_cNvPr:
	{
		AttributeList aAttribs( xAttribs );
		mpGroupShapePtr->setHidden( aAttribs.getBool( XML_hidden, false ) );
		mpGroupShapePtr->setId( xAttribs->getOptionalValue( XML_id ) );
		mpGroupShapePtr->setName( xAttribs->getOptionalValue( XML_name ) );
		break;
	}
	case XML_ph:
		mpGroupShapePtr->setSubType( xAttribs->getOptionalValueToken( XML_type, FastToken::DONTKNOW ) );
		mpGroupShapePtr->setSubTypeIndex( xAttribs->getOptionalValue( XML_idx ).toInt32() );
		break;
	// nvSpPr CT_ShapeNonVisual end

	case XML_grpSpPr:
        xRet = new ShapePropertiesContext( *this, *mpGroupShapePtr );
		break;
	case XML_spPr:
        xRet = new ShapePropertiesContext( *this, *mpGroupShapePtr );
		break;
/*
	case XML_style:
		xRet = new ShapeStyleContext( getParser() );
		break;
*/
	case XML_cxnSp:			// connector shape
        xRet.set( new ConnectorShapeContext( *this, mpGroupShapePtr, ShapePtr( new Shape( "com.sun.star.drawing.ConnectorShape" ) ) ) );
		break;
	case XML_grpSp:			// group shape
        xRet.set( new ShapeGroupContext( *this, mpGroupShapePtr, ShapePtr( new Shape( "com.sun.star.drawing.GroupShape" ) ) ) );
		break;
	case XML_sp:			// shape
        xRet.set( new ShapeContext( *this, mpGroupShapePtr, ShapePtr( new Shape( "com.sun.star.drawing.CustomShape" ) ) ) );
		break;
	case XML_pic:			// CT_Picture
        xRet.set( new GraphicShapeContext( *this, mpGroupShapePtr, ShapePtr( new Shape( "com.sun.star.drawing.GraphicObjectShape" ) ) ) );
		break;
	case XML_graphicFrame:	// CT_GraphicalObjectFrame
        xRet.set( new GraphicalObjectFrameContext( *this, mpGroupShapePtr, ShapePtr( new Shape( "com.sun.star.drawing.GraphicObjectShape" ) ), true ) );
		break;
	}
	if( !xRet.is() )
		xRet.set( this );


	return xRet;
}

} }
