/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



#include "diagramdefinitioncontext.hxx"
#include "oox/helper/helper.hxx"
#include "layoutnodecontext.hxx"
#include "oox/drawingml/diagram/datamodelcontext.hxx"

using namespace ::oox::core;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::xml::sax;
using ::rtl::OUString;

namespace oox { namespace drawingml {


// CT_DiagramDefinition
DiagramDefinitionContext::DiagramDefinitionContext( ContextHandler& rParent,
													const Reference< XFastAttributeList >& xAttributes,
													const DiagramLayoutPtr &pLayout )
    : ContextHandler( rParent )
	, mpLayout( pLayout )
{
	OSL_TRACE( "OOX: DiagramDefinitionContext::DiagramDefinitionContext()" );
	mpLayout->setDefStyle( xAttributes->getOptionalValue( XML_defStyle ) );
	OUString sValue = xAttributes->getOptionalValue( XML_minVer );
	if( sValue.getLength() == 0 )
	{
		sValue = CREATE_OUSTRING( "http://schemas.openxmlformats.org/drawingml/2006/diagram" );
	}
	mpLayout->setMinVer( sValue );
	mpLayout->setUniqueId( xAttributes->getOptionalValue( XML_uniqueId ) );
}


DiagramDefinitionContext::~DiagramDefinitionContext()
{
	mpLayout->getNode()->dump(0);
}

void SAL_CALL DiagramDefinitionContext::endFastElement( ::sal_Int32 )
	throw (SAXException, RuntimeException)
{

}


Reference< XFastContextHandler > SAL_CALL
DiagramDefinitionContext::createFastChildContext( ::sal_Int32 aElement,
												  const Reference< XFastAttributeList >& xAttribs )
	throw (SAXException, RuntimeException)
{
	Reference< XFastContextHandler > xRet;

	switch( aElement )
	{
	case DGM_TOKEN( title ):
		mpLayout->setTitle( xAttribs->getOptionalValue( XML_val ) );
		break;
	case DGM_TOKEN( desc ):
		mpLayout->setDesc( xAttribs->getOptionalValue( XML_val ) );
		break;
	case DGM_TOKEN( layoutNode ):
		mpLayout->getNode().reset( new LayoutNode() );
        xRet.set( new LayoutNodeContext( *this, xAttribs, mpLayout->getNode() ) );
		break;
 	case DGM_TOKEN( clrData ):
		// TODO, does not matter for the UI. skip.
        return xRet;
	case DGM_TOKEN( sampData ):
		mpLayout->getSampData().reset( new DiagramData );
        xRet.set( new DataModelContext( *this, mpLayout->getSampData() ) );
		break;
	case DGM_TOKEN( styleData ):
		mpLayout->getStyleData().reset( new DiagramData );
        xRet.set( new DataModelContext( *this, mpLayout->getStyleData() ) );
		break;
	case DGM_TOKEN( cat ):
	case DGM_TOKEN( catLst ):
		// TODO, does not matter for the UI
	default:
		break;
	}
	if( !xRet.is() )
		xRet.set(this);

	return xRet;
}


} }
