/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



#ifndef OOX_DRAWINGML_CHART_TITLECONVERTER_HXX
#define OOX_DRAWINGML_CHART_TITLECONVERTER_HXX

#include "oox/drawingml/chart/converterbase.hxx"

namespace com { namespace sun { namespace star {
    namespace chart2 { class XDiagram; }
    namespace chart2 { class XFormattedString; }
    namespace chart2 { class XTitled; }
    namespace chart2 { namespace data { class XDataSequence; } }
} } }

namespace oox { namespace drawingml { struct TextCharacterProperties; } }

namespace oox {
namespace drawingml {
namespace chart {

// ============================================================================

struct TextModel;

class TextConverter : public ConverterBase< TextModel >
{
public:
    explicit            TextConverter( const ConverterRoot& rParent, TextModel& rModel );
    virtual             ~TextConverter();

    /** Creates a data sequence object from the contained text data. */
    ::com::sun::star::uno::Reference< ::com::sun::star::chart2::data::XDataSequence >
                        createDataSequence( const ::rtl::OUString& rRole );
    /** Creates a sequence of formatted string objects. */
    ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Reference< ::com::sun::star::chart2::XFormattedString > >
                        createStringSequence(
                            const ::rtl::OUString& rDefaultText,
                            const ModelRef< TextBody >& rxTextProp,
                            ObjectType eObjType );

private:
    ::com::sun::star::uno::Reference< ::com::sun::star::chart2::XFormattedString >
                        appendFormattedString(
                            ::std::vector< ::com::sun::star::uno::Reference< ::com::sun::star::chart2::XFormattedString > >& orStringVec,
                            const ::rtl::OUString& rString,
                            bool bAddNewLine ) const;
};

// ============================================================================

struct TitleModel;

class TitleConverter : public ConverterBase< TitleModel >
{
public:
    explicit            TitleConverter( const ConverterRoot& rParent, TitleModel& rModel );
    virtual             ~TitleConverter();

    /** Creates a title text object and attaches it at the passed interface. */
    void                convertFromModel(
                            const ::com::sun::star::uno::Reference< ::com::sun::star::chart2::XTitled >& rxTitled,
                            const ::rtl::OUString& rAutoTitle, ObjectType eObjType,
                            sal_Int32 nMainIdx = -1, sal_Int32 nSubIdx = -1 );
};

// ============================================================================

struct LegendModel;

class LegendConverter : public ConverterBase< LegendModel >
{
public:
    explicit            LegendConverter( const ConverterRoot& rParent, LegendModel& rModel );
    virtual             ~LegendConverter();

    /** Creates a legend object and attaches it at the passed diagram. */
    void                convertFromModel(
                            const ::com::sun::star::uno::Reference< ::com::sun::star::chart2::XDiagram >& rxDiagram );
};

// ============================================================================

} // namespace chart
} // namespace drawingml
} // namespace oox

#endif
