/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



package com.sun.star.comp.helper;

import com.sun.star.comp.loader.JavaLoader;

import com.sun.star.comp.servicemanager.ServiceManager;
import com.sun.star.uno.UnoRuntime;

import com.sun.star.container.XSet;
import com.sun.star.container.XContentEnumerationAccess;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.container.XElementAccess;

import com.sun.star.lang.XComponent;

import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.lang.XInitialization;

import com.sun.star.loader.XImplementationLoader;

import com.sun.star.registry.XSimpleRegistry;

public class RegistryServiceFactory_Test {
	
	static public boolean test(String applicat) throws java.lang.Exception {
		boolean passed = false;
		System.err.println();			
		System.out.println("*******************************************************************");
		System.err.println("RegistryServiceFactory - doing tests...");
		System.err.println();

		try {
			XMultiServiceFactory msf = RegistryServiceFactory.create( applicat );
			String services[] = msf.getAvailableServiceNames();
			System.out.println("Available services are:");
			System.err.println();
			if (services.length == 0)
				System.out.println("No services avialable!");

			else 			
				for ( int i=0; i<services.length; i++ )
					System.out.println(services[i]);
					
			passed = true;
		}		
		catch (Exception e) {
			e.printStackTrace();
		}
		System.err.println();
		System.err.println("RegistryServiceFactory test passed? " + passed);
		System.out.println("*******************************************************************");
		System.err.println();
		return passed;
	}

	private static void usage() {
		System.out.println();
		System.out.println("usage:");
		System.out.println("java com.sun.star.comp.helper.RegistryServiceFactory [rdb-file]");
		System.out.println("example:");
		System.out.println("java com.sun.star.comp.helper.RegistryServiceFactory c:\\applicat.rdb");
		System.exit( -1 );
	}

	static public void main(String args[]) throws java.lang.Exception {
		if ( args.length != 1 )
			usage();
		System.exit( test(args[0]) == true ? 0: -1 );		
	}
}

