/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_i18npool.hxx"

// prevent internal compiler error with MSVC6SP3
#include <utility>

#define TRANSLITERATION_TraditionalKanji_ja_JP
#include <transliteration_Ignore.hxx>

namespace com { namespace sun { namespace star { namespace i18n {

// traditional Kanji characters --> modern Kanji characters
OneToOneMappingTable_t traditionalKanji2updateKanji[] = {
    MAKE_PAIR( 0x4E17, 0x4E16 ),
    MAKE_PAIR( 0x4E55, 0x864E ),
    MAKE_PAIR( 0x4E58, 0x4E57 ),
    MAKE_PAIR( 0x4E82, 0x4E71 ),
    MAKE_PAIR( 0x4E8A, 0x4E8B ),
    MAKE_PAIR( 0x4E98, 0x4E99 ),
    MAKE_PAIR( 0x4E9F, 0x6975 ),
    MAKE_PAIR( 0x4EB0, 0x4EAC ),
    MAKE_PAIR( 0x4EC2, 0x50CD ),
    MAKE_PAIR( 0x4ECE, 0x5F93 ),
    MAKE_PAIR( 0x4EED, 0x4EDE ),
    MAKE_PAIR( 0x4F1C, 0x5005 ),
    MAKE_PAIR( 0x4F5B, 0x4ECF ),
    MAKE_PAIR( 0x4F86, 0x6765 ),
    MAKE_PAIR( 0x4FAB, 0x4F5E ),
    MAKE_PAIR( 0x5047, 0x4EEE ),
    MAKE_PAIR( 0x509A, 0x52B9 ),
    MAKE_PAIR( 0x50B3, 0x4F1D ),
    MAKE_PAIR( 0x50DE, 0x507D ),
    MAKE_PAIR( 0x50E3, 0x50ED ),
    MAKE_PAIR( 0x50F9, 0x4FA1 ),
    MAKE_PAIR( 0x5109, 0x5039 ),
    MAKE_PAIR( 0x5118, 0x4FAD ),
    MAKE_PAIR( 0x5152, 0x5150 ),
    MAKE_PAIR( 0x5154, 0x514E ),
    MAKE_PAIR( 0x5169, 0x4E21 ),
    MAKE_PAIR( 0x518C, 0x518A ),
    MAKE_PAIR( 0x5190, 0x5192 ),
    MAKE_PAIR( 0x51A8, 0x5BCC ),
    MAKE_PAIR( 0x51A9, 0x5199 ),
    MAKE_PAIR( 0x51B0, 0x6C37 ),
    MAKE_PAIR( 0x51B1, 0x51B4 ),
    MAKE_PAIR( 0x51B2, 0x6C96 ),
    MAKE_PAIR( 0x51B3, 0x6C7A ),
    MAKE_PAIR( 0x51B5, 0x6CC1 ),
    MAKE_PAIR( 0x51C9, 0x6DBC ),
    MAKE_PAIR( 0x51D6, 0x6E96 ),
    MAKE_PAIR( 0x51DC, 0x51DB ),
    MAKE_PAIR( 0x51FE, 0x51FD ),
    MAKE_PAIR( 0x5204, 0x5203 ),
    MAKE_PAIR( 0x5227, 0x52AB ),
    MAKE_PAIR( 0x5269, 0x5270 ),
    MAKE_PAIR( 0x5271, 0x5263 ),
    MAKE_PAIR( 0x5283, 0x753B ),
    MAKE_PAIR( 0x528D, 0x5263 ),
    MAKE_PAIR( 0x5291, 0x5264 ),
    MAKE_PAIR( 0x5292, 0x5263 ),
    MAKE_PAIR( 0x5294, 0x5263 ),
    MAKE_PAIR( 0x52B5, 0x5238 ),
    MAKE_PAIR( 0x52DE, 0x52B4 ),
    MAKE_PAIR( 0x52F3, 0x52F2 ),
    MAKE_PAIR( 0x52F5, 0x52B1 ),
    MAKE_PAIR( 0x52F8, 0x52E7 ),
    MAKE_PAIR( 0x5340, 0x533A ),
    MAKE_PAIR( 0x5346, 0x5352 ),
    MAKE_PAIR( 0x5377, 0x5DFB ),
    MAKE_PAIR( 0x537B, 0x5374 ),
    MAKE_PAIR( 0x53B0, 0x5EE0 ),
    MAKE_PAIR( 0x53C3, 0x53C2 ),
    MAKE_PAIR( 0x548F, 0x8A60 ),
    MAKE_PAIR( 0x5492, 0x546A ),
    MAKE_PAIR( 0x54AF, 0x5580 ),
    MAKE_PAIR( 0x54E5, 0x6B4C ),
    MAKE_PAIR( 0x5557, 0x5556 ),
    MAKE_PAIR( 0x55AE, 0x5358 ),
    MAKE_PAIR( 0x5650, 0x5668 ),
    MAKE_PAIR( 0x5680, 0x5BE7 ),
    MAKE_PAIR( 0x568F, 0x5694 ),
    MAKE_PAIR( 0x56B4, 0x53B3 ),
    MAKE_PAIR( 0x56D1, 0x5631 ),
    MAKE_PAIR( 0x56D8, 0x56DE ),
    MAKE_PAIR( 0x5708, 0x570F ),
    MAKE_PAIR( 0x570B, 0x56FD ),
    MAKE_PAIR( 0x570D, 0x56F2 ),
    MAKE_PAIR( 0x5713, 0x5186 ),
    MAKE_PAIR( 0x5716, 0x56F3 ),
    MAKE_PAIR( 0x5718, 0x56E3 ),
    MAKE_PAIR( 0x57C0, 0x5782 ),
    MAKE_PAIR( 0x57D3, 0x57D2 ),
    MAKE_PAIR( 0x57FC, 0x5D0E ),
    MAKE_PAIR( 0x582F, 0x5C2D ),
    MAKE_PAIR( 0x5872, 0x5834 ),
    MAKE_PAIR( 0x58AE, 0x5815 ),
    MAKE_PAIR( 0x58D3, 0x5727 ),
    MAKE_PAIR( 0x58D8, 0x5841 ),
    MAKE_PAIR( 0x58DE, 0x58CA ),
    MAKE_PAIR( 0x58E4, 0x58CC ),
    MAKE_PAIR( 0x58EF, 0x58EE ),
    MAKE_PAIR( 0x58F1, 0x4E00 ),
    MAKE_PAIR( 0x58F9, 0x4E00 ),
    MAKE_PAIR( 0x58FA, 0x58F7 ),
    MAKE_PAIR( 0x58FB, 0x5A7F ),
    MAKE_PAIR( 0x58FD, 0x5BFF ),
    MAKE_PAIR( 0x5918, 0x536F ),
    MAKE_PAIR( 0x591B, 0x591A ),
    MAKE_PAIR( 0x5932, 0x672C ),
    MAKE_PAIR( 0x5967, 0x5965 ),
    MAKE_PAIR( 0x5969, 0x5333 ),
    MAKE_PAIR( 0x596C, 0x5968 ),
    MAKE_PAIR( 0x59D9, 0x598A ),
    MAKE_PAIR( 0x5A6C, 0x6DEB ),
    MAKE_PAIR( 0x5AD0, 0x5B32 ),
    MAKE_PAIR( 0x5AFB, 0x5AFA ),
    MAKE_PAIR( 0x5B43, 0x5B22 ),
    MAKE_PAIR( 0x5B78, 0x5B66 ),
    //    MAKE_PAIR( 0x5B9D, 0x73CD ),
    MAKE_PAIR( 0x5BC3, 0x51A4 ),
    MAKE_PAIR( 0x5BC7, 0x51A6 ),
    MAKE_PAIR( 0x5BC9, 0x9DB4 ),
    MAKE_PAIR( 0x5BE2, 0x5BDD ),
    MAKE_PAIR( 0x5BE6, 0x5B9F ),
    MAKE_PAIR( 0x5BEB, 0x5199 ),
    //MAKE_PAIR( 0x5BF3, 0x73CD ),
    MAKE_PAIR( 0x5BF3, 0x5B9D ),
    //MAKE_PAIR( 0x5BF6, 0x73CD ),
    MAKE_PAIR( 0x5BF6, 0x5B9D ),
    MAKE_PAIR( 0x5C05, 0x524B ),
    MAKE_PAIR( 0x5C07, 0x5C06 ),
    MAKE_PAIR( 0x5C08, 0x5C02 ),
    MAKE_PAIR( 0x5C0D, 0x5BFE ),
    MAKE_PAIR( 0x5C13, 0x723E ),
    MAKE_PAIR( 0x5C46, 0x5C4A ),
    MAKE_PAIR( 0x5C6C, 0x5C5E ),
    MAKE_PAIR( 0x5CE9, 0x5CE8 ),
    MAKE_PAIR( 0x5CEF, 0x5CF0 ),
    MAKE_PAIR( 0x5CFD, 0x5CE1 ),
    MAKE_PAIR( 0x5D15, 0x5D16 ),
    MAKE_PAIR( 0x5D17, 0x5CA1 ),
    MAKE_PAIR( 0x5D18, 0x5D19 ),
    MAKE_PAIR( 0x5D5C, 0x5D0E ),
    MAKE_PAIR( 0x5D73, 0x5D6F ),
    MAKE_PAIR( 0x5D8B, 0x5CF6 ),
    MAKE_PAIR( 0x5D8C, 0x5CF6 ),
    MAKE_PAIR( 0x5DBD, 0x5CB3 ),
    MAKE_PAIR( 0x5DD6, 0x5DCC ),
    MAKE_PAIR( 0x5DDB, 0x5DDD ),
    MAKE_PAIR( 0x5DF5, 0x536E ),
    MAKE_PAIR( 0x5E0B, 0x7D19 ),
    MAKE_PAIR( 0x5E36, 0x5E2F ),
    MAKE_PAIR( 0x5E64, 0x5E63 ),
    MAKE_PAIR( 0x5EC1, 0x53A0 ),
    MAKE_PAIR( 0x5EC8, 0x53A6 ),
    MAKE_PAIR( 0x5ECF, 0x53A9 ),
    MAKE_PAIR( 0x5ED0, 0x53A9 ),
    MAKE_PAIR( 0x5EDA, 0x53A8 ),
    MAKE_PAIR( 0x5EDD, 0x53AE ),
    MAKE_PAIR( 0x5EE2, 0x5EC3 ),
    MAKE_PAIR( 0x5EE3, 0x5E83 ),
    MAKE_PAIR( 0x5EF0, 0x5E81 ),
    MAKE_PAIR( 0x5EF3, 0x5E81 ),
    MAKE_PAIR( 0x5F03, 0x68C4 ),
    MAKE_PAIR( 0x5F09, 0x5958 ),
    MAKE_PAIR( 0x5F0C, 0x4E00 ),
    MAKE_PAIR( 0x5F0D, 0x4E8C ),
    MAKE_PAIR( 0x5F10, 0x4E8C ),
    MAKE_PAIR( 0x5F2F, 0x6E7E ),
    MAKE_PAIR( 0x5F48, 0x5F3E ),
    MAKE_PAIR( 0x5F4C, 0x5F25 ),
    MAKE_PAIR( 0x5F4E, 0x6E7E ),
    MAKE_PAIR( 0x5F5C, 0x5F5D ),
    MAKE_PAIR( 0x5F83, 0x5F80 ),
    MAKE_PAIR( 0x5F91, 0x5F84 ),
    MAKE_PAIR( 0x5F9E, 0x5F93 ),
    MAKE_PAIR( 0x5FA0, 0x6765 ),
    MAKE_PAIR( 0x5FF0, 0x60B4 ),
    MAKE_PAIR( 0x5FFB, 0x6B23 ),
    MAKE_PAIR( 0x6046, 0x6052 ),
    MAKE_PAIR( 0x604A, 0x5354 ),
    MAKE_PAIR( 0x6060, 0x602A ),
    MAKE_PAIR( 0x60B3, 0x5FB3 ),
    MAKE_PAIR( 0x60E0, 0x6075 ),
    MAKE_PAIR( 0x60E1, 0x60AA ),
    MAKE_PAIR( 0x60F1, 0x60A9 ),
    MAKE_PAIR( 0x613C, 0x614E ),
    MAKE_PAIR( 0x613D, 0x535A ),
    MAKE_PAIR( 0x6158, 0x60E8 ),
    MAKE_PAIR( 0x615A, 0x6159 ),
    MAKE_PAIR( 0x6187, 0x61A9 ),
    MAKE_PAIR( 0x61C9, 0x5FDC ),
    MAKE_PAIR( 0x61F4, 0x61FA ),
    MAKE_PAIR( 0x61F7, 0x61D0 ),
    MAKE_PAIR( 0x6200, 0x604B ),
    MAKE_PAIR( 0x621D, 0x8CA1 ),
    MAKE_PAIR( 0x621E, 0x621B ),
    MAKE_PAIR( 0x6230, 0x6226 ),
    MAKE_PAIR( 0x6232, 0x622F ),
    MAKE_PAIR( 0x6268, 0x6260 ),
    MAKE_PAIR( 0x62AC, 0x64E1 ),
    MAKE_PAIR( 0x62C2, 0x6255 ),
    MAKE_PAIR( 0x62D4, 0x629C ),
    MAKE_PAIR( 0x62DC, 0x62DD ),
    MAKE_PAIR( 0x633E, 0x631F ),
    MAKE_PAIR( 0x63D2, 0x633F ),
    MAKE_PAIR( 0x6416, 0x63FA ),
    MAKE_PAIR( 0x641C, 0x635C ),
    MAKE_PAIR( 0x64C7, 0x629E ),
    MAKE_PAIR( 0x64D4, 0x62C5 ),
    MAKE_PAIR( 0x64DA, 0x62E0 ),
    MAKE_PAIR( 0x64E7, 0x6319 ),
    MAKE_PAIR( 0x64F4, 0x62E1 ),
    MAKE_PAIR( 0x651C, 0x643A ),
    MAKE_PAIR( 0x651D, 0x6442 ),
    MAKE_PAIR( 0x652A, 0x64B9 ),
    MAKE_PAIR( 0x6536, 0x53CE ),
    MAKE_PAIR( 0x6548, 0x52B9 ),
    MAKE_PAIR( 0x654D, 0x53D9 ),
    MAKE_PAIR( 0x6555, 0x52C5 ),
    MAKE_PAIR( 0x6558, 0x53D9 ),
    MAKE_PAIR( 0x6578, 0x6570 ),
    MAKE_PAIR( 0x6588, 0x5B66 ),
    MAKE_PAIR( 0x6589, 0x658E ),
    MAKE_PAIR( 0x65B7, 0x65AD ),
    MAKE_PAIR( 0x65D9, 0x65DB ),
    MAKE_PAIR( 0x663F, 0x66E0 ),
    MAKE_PAIR( 0x6644, 0x6643 ),
    MAKE_PAIR( 0x6649, 0x664B ),
    MAKE_PAIR( 0x665D, 0x663C ),
    MAKE_PAIR( 0x668E, 0x6620 ),
    MAKE_PAIR( 0x66B8, 0x77AD ),
    MAKE_PAIR( 0x66C9, 0x6681 ),
    MAKE_PAIR( 0x66F0, 0x4E91 ),
    MAKE_PAIR( 0x66F5, 0x66F3 ),
    MAKE_PAIR( 0x66FD, 0x66FE ),
    MAKE_PAIR( 0x6703, 0x4F1A ),
    MAKE_PAIR( 0x6716, 0x6717 ),
    MAKE_PAIR( 0x671E, 0x671F ),
    MAKE_PAIR( 0x6764, 0x6803 ),
    MAKE_PAIR( 0x67A1, 0x685D ),
    MAKE_PAIR( 0x67A6, 0x6AE8 ),
    MAKE_PAIR( 0x67A9, 0x677E ),
    MAKE_PAIR( 0x67CF, 0x6822 ),
    MAKE_PAIR( 0x6816, 0x68F2 ),
    MAKE_PAIR( 0x6840, 0x685D ),
    MAKE_PAIR( 0x689D, 0x6761 ),
    MAKE_PAIR( 0x68A6, 0x5922 ),
    MAKE_PAIR( 0x68CA, 0x68CB ),
    MAKE_PAIR( 0x68E7, 0x685F ),
    MAKE_PAIR( 0x6936, 0x68D5 ),
    MAKE_PAIR( 0x695D, 0x68DF ),
    MAKE_PAIR( 0x6973, 0x6885 ),
    MAKE_PAIR( 0x69AE, 0x6804 ),
    MAKE_PAIR( 0x69C7, 0x69D9 ),
    MAKE_PAIR( 0x6A02, 0x697D ),
    MAKE_PAIR( 0x6A13, 0x697C ),
    MAKE_PAIR( 0x6A1E, 0x67A2 ),
    MAKE_PAIR( 0x6A23, 0x69D8 ),
    MAKE_PAIR( 0x6A62, 0x6955 ),
    MAKE_PAIR( 0x6A9C, 0x6867 ),
    MAKE_PAIR( 0x6AA2, 0x691C ),
    MAKE_PAIR( 0x6AAA, 0x6ADF ),
    MAKE_PAIR( 0x6AAE, 0x68BC ),
    MAKE_PAIR( 0x6AB3, 0x68B9 ),
    MAKE_PAIR( 0x6AC1, 0x6A12 ),
    MAKE_PAIR( 0x6AFB, 0x685C ),
    MAKE_PAIR( 0x6B0A, 0x6A29 ),
    MAKE_PAIR( 0x6B50, 0x6B27 ),
    MAKE_PAIR( 0x6B61, 0x6B53 ),
    MAKE_PAIR( 0x6B78, 0x5E30 ),
    MAKE_PAIR( 0x6B7F, 0x6CA1 ),
    MAKE_PAIR( 0x6B98, 0x6B8B ),
    MAKE_PAIR( 0x6BB1, 0x6BB2 ),
    MAKE_PAIR( 0x6BBC, 0x6BBB ),
    MAKE_PAIR( 0x6BC6, 0x6BB4 ),
    MAKE_PAIR( 0x6BCB, 0x6BCD ),
    MAKE_PAIR( 0x6BD3, 0x80B2 ),
    MAKE_PAIR( 0x6C23, 0x6C17 ),
    MAKE_PAIR( 0x6C8D, 0x51B4 ),
    MAKE_PAIR( 0x6C92, 0x6CA1 ),
    MAKE_PAIR( 0x6CEA, 0x6D99 ),
    MAKE_PAIR( 0x6D0C, 0x51BD ),
    MAKE_PAIR( 0x6D35, 0x5F87 ),
    MAKE_PAIR( 0x6D79, 0x5CE1 ),
    MAKE_PAIR( 0x6D8C, 0x6E67 ),
    MAKE_PAIR( 0x6DB8, 0x51C5 ),
    MAKE_PAIR( 0x6DD2, 0x51C4 ),
    MAKE_PAIR( 0x6DE8, 0x6D44 ),
    MAKE_PAIR( 0x6DFA, 0x6D45 ),
    MAKE_PAIR( 0x6E0A, 0x6DF5 ),
    MAKE_PAIR( 0x6E15, 0x6DF5 ),
    MAKE_PAIR( 0x6EAA, 0x6E13 ),
    MAKE_PAIR( 0x6EAF, 0x9061 ),
    MAKE_PAIR( 0x6EEF, 0x6EDE ),
    MAKE_PAIR( 0x6EFF, 0x6E80 ),
    MAKE_PAIR( 0x6F5B, 0x6F5C ),
    MAKE_PAIR( 0x6F74, 0x7026 ),
    MAKE_PAIR( 0x6F80, 0x6E0B ),
    MAKE_PAIR( 0x6F81, 0x6E0B ),
    MAKE_PAIR( 0x6F82, 0x6F84 ),
    MAKE_PAIR( 0x6F91, 0x6E9C ),
    MAKE_PAIR( 0x6FA4, 0x6CA2 ),
    MAKE_PAIR( 0x6FD5, 0x6E7F ),
    MAKE_PAIR( 0x6FDF, 0x6E08 ),
    MAKE_PAIR( 0x6FE4, 0x6D9B ),
    MAKE_PAIR( 0x6FF1, 0x6D5C ),
    MAKE_PAIR( 0x6FF3, 0x6F5C ),
    MAKE_PAIR( 0x6FF6, 0x95CA ),
    MAKE_PAIR( 0x7027, 0x6EDD ),
    MAKE_PAIR( 0x7030, 0x6FD4 ),
    MAKE_PAIR( 0x704C, 0x6F45 ),
    MAKE_PAIR( 0x7063, 0x6E7E ),
    MAKE_PAIR( 0x70CB, 0x6077 ),
    MAKE_PAIR( 0x70DF, 0x7159 ),
    MAKE_PAIR( 0x70F1, 0x70AF ),
    MAKE_PAIR( 0x7188, 0x7155 ),
    MAKE_PAIR( 0x7199, 0x7155 ),
    MAKE_PAIR( 0x71C8, 0x706F ),
    MAKE_PAIR( 0x71D2, 0x713C ),
    MAKE_PAIR( 0x71DF, 0x55B6 ),
    MAKE_PAIR( 0x71FB, 0x718F ),
    MAKE_PAIR( 0x71FF, 0x8000 ),
    MAKE_PAIR( 0x7210, 0x7089 ),
    MAKE_PAIR( 0x722D, 0x4E89 ),
    MAKE_PAIR( 0x7232, 0x70BA ),
    MAKE_PAIR( 0x723C, 0x4FCE ),
    MAKE_PAIR( 0x7246, 0x58BB ),
    MAKE_PAIR( 0x7281, 0x7282 ),
    MAKE_PAIR( 0x72A7, 0x72A0 ),
    MAKE_PAIR( 0x72E2, 0x72F8 ),
    MAKE_PAIR( 0x72F9, 0x72ED ),
    MAKE_PAIR( 0x734E, 0x5968 ),
    MAKE_PAIR( 0x7368, 0x72EC ),
    MAKE_PAIR( 0x7375, 0x731F ),
    MAKE_PAIR( 0x7378, 0x7363 ),
    MAKE_PAIR( 0x737B, 0x732E ),
    MAKE_PAIR( 0x73CE, 0x73CD ),
    MAKE_PAIR( 0x73F1, 0x74D4 ),
    MAKE_PAIR( 0x7464, 0x7476 ),
    MAKE_PAIR( 0x746F, 0x7405 ),
    MAKE_PAIR( 0x74A2, 0x7460 ),
    MAKE_PAIR( 0x74E3, 0x5F01 ),
    MAKE_PAIR( 0x751E, 0x5617 ),
    MAKE_PAIR( 0x753C, 0x753A ),
    MAKE_PAIR( 0x7544, 0x7559 ),
    MAKE_PAIR( 0x7546, 0x755D ),
    MAKE_PAIR( 0x754A, 0x8015 ),
    MAKE_PAIR( 0x754D, 0x754C ),
    MAKE_PAIR( 0x7567, 0x7565 ),
    MAKE_PAIR( 0x756B, 0x753B ),
    MAKE_PAIR( 0x7574, 0x7587 ),
    MAKE_PAIR( 0x7576, 0x5F53 ),
    MAKE_PAIR( 0x7582, 0x7573 ),
    MAKE_PAIR( 0x7589, 0x7573 ),
    MAKE_PAIR( 0x758A, 0x7573 ),
    MAKE_PAIR( 0x7609, 0x7652 ),
    MAKE_PAIR( 0x7661, 0x75F4 ),
    MAKE_PAIR( 0x767C, 0x767A ),
    MAKE_PAIR( 0x7683, 0x8C8C ),
    MAKE_PAIR( 0x7688, 0x5E30 ),
    MAKE_PAIR( 0x768B, 0x7690 ),
    MAKE_PAIR( 0x7693, 0x6667 ),
    MAKE_PAIR( 0x76B7, 0x9F13 ),
    MAKE_PAIR( 0x76B9, 0x76B8 ),
    MAKE_PAIR( 0x76C3, 0x676F ),
    MAKE_PAIR( 0x76D6, 0x84CB ),
    MAKE_PAIR( 0x76DC, 0x76D7 ),
    MAKE_PAIR( 0x76E1, 0x5C3D ),
    MAKE_PAIR( 0x771E, 0x771F ),
    MAKE_PAIR( 0x7726, 0x7725 ),
    MAKE_PAIR( 0x777F, 0x53E1 ),
    MAKE_PAIR( 0x783F, 0x9271 ),
    MAKE_PAIR( 0x7845, 0x73EA ),
    MAKE_PAIR( 0x788E, 0x7815 ),
    MAKE_PAIR( 0x7895, 0x5D0E ),
    MAKE_PAIR( 0x78AF, 0x7459 ),
    MAKE_PAIR( 0x7919, 0x788D ),
    MAKE_PAIR( 0x7926, 0x9271 ),
    MAKE_PAIR( 0x792A, 0x783A ),
    MAKE_PAIR( 0x7955, 0x79D8 ),
    MAKE_PAIR( 0x7962, 0x79B0 ),
    MAKE_PAIR( 0x797F, 0x7984 ),
    MAKE_PAIR( 0x7980, 0x7A1F ),
    MAKE_PAIR( 0x79AA, 0x7985 ),
    MAKE_PAIR( 0x79AE, 0x793C ),
    MAKE_PAIR( 0x79CB, 0x7A50 ),
    MAKE_PAIR( 0x7A31, 0x79F0 ),
    MAKE_PAIR( 0x7A3B, 0x7A32 ),
    MAKE_PAIR( 0x7A3E, 0x7A3F ),
    MAKE_PAIR( 0x7A49, 0x7A1A ),
    MAKE_PAIR( 0x7A57, 0x7A42 ),
    MAKE_PAIR( 0x7A69, 0x7A4F ),
    MAKE_PAIR( 0x7A70, 0x7A63 ),
    MAKE_PAIR( 0x7A97, 0x7A93 ),
    MAKE_PAIR( 0x7AB0, 0x7AAF ),
    MAKE_PAIR( 0x7AC8, 0x7AC3 ),
    MAKE_PAIR( 0x7ACA, 0x7A83 ),
    MAKE_PAIR( 0x7AD2, 0x5947 ),
    MAKE_PAIR( 0x7ADD, 0x4E26 ),
    MAKE_PAIR( 0x7B0B, 0x7B4D ),
    MAKE_PAIR( 0x7B11, 0x54B2 ),
    MAKE_PAIR( 0x7B5D, 0x7B8F ),
    MAKE_PAIR( 0x7B71, 0x7BE0 ),
    MAKE_PAIR( 0x7B7A, 0x7B50 ),
    MAKE_PAIR( 0x7B8B, 0x724B ),
    MAKE_PAIR( 0x7B9A, 0x5273 ),
    MAKE_PAIR( 0x7B9F, 0x7B98 ),
    MAKE_PAIR( 0x7BCF, 0x5D4C ),
    MAKE_PAIR( 0x7BE6, 0x7B86 ),
    MAKE_PAIR( 0x7C11, 0x84D1 ),
    MAKE_PAIR( 0x7C14, 0x84D1 ),
    MAKE_PAIR( 0x7C54, 0x85AE ),
    MAKE_PAIR( 0x7C56, 0x7C64 ),
    MAKE_PAIR( 0x7C58, 0x7C50 ),
    MAKE_PAIR( 0x7C60, 0x7BED ),
    MAKE_PAIR( 0x7CAE, 0x7CE7 ),
    MAKE_PAIR( 0x7CB9, 0x7C8B ),
    MAKE_PAIR( 0x7CE2, 0x6A21 ),
    MAKE_PAIR( 0x7CFA, 0x7CFE ),
    MAKE_PAIR( 0x7D4F, 0x7D32 ),
    MAKE_PAIR( 0x7D72, 0x7CF8 ),
    MAKE_PAIR( 0x7D89, 0x7E4D ),
    MAKE_PAIR( 0x7D93, 0x7D4C ),
    MAKE_PAIR( 0x7DAB, 0x7DDA ),
    MAKE_PAIR( 0x7DD5, 0x7E83 ),
    MAKE_PAIR( 0x7DDC, 0x7DBF ),
    MAKE_PAIR( 0x7DE8, 0x7BC7 ),
    MAKE_PAIR( 0x7E23, 0x770C ),
    MAKE_PAIR( 0x7E31, 0x7E26 ),
    MAKE_PAIR( 0x7E3D, 0x7DCF ),
    MAKE_PAIR( 0x7E69, 0x7E04 ),
    MAKE_PAIR( 0x7E6A, 0x7D75 ),
    MAKE_PAIR( 0x7E7C, 0x7D99 ),
    MAKE_PAIR( 0x7E8C, 0x7D9A ),
    MAKE_PAIR( 0x7E8E, 0x7E4A ),
    MAKE_PAIR( 0x7E92, 0x7E8F ),
    MAKE_PAIR( 0x7E96, 0x7E4A ),
    MAKE_PAIR( 0x7F3A, 0x6B20 ),
    MAKE_PAIR( 0x7F4E, 0x58DC ),
    MAKE_PAIR( 0x7F50, 0x7F36 ),
    MAKE_PAIR( 0x7F78, 0x7F70 ),
    MAKE_PAIR( 0x7F83, 0x51AA ),
    MAKE_PAIR( 0x7F87, 0x7F88 ),
    MAKE_PAIR( 0x7FA3, 0x7FA4 ),
    MAKE_PAIR( 0x7FAE, 0x7FB9 ),
    MAKE_PAIR( 0x7FC6, 0x7FE0 ),
    MAKE_PAIR( 0x803B, 0x6065 ),
    MAKE_PAIR( 0x805F, 0x5A7F ),
    MAKE_PAIR( 0x8068, 0x806F ),
    MAKE_PAIR( 0x8070, 0x8061 ),
    MAKE_PAIR( 0x8072, 0x58F0 ),
    MAKE_PAIR( 0x807D, 0x8074 ),
    MAKE_PAIR( 0x8085, 0x7C9B ),
    MAKE_PAIR( 0x8089, 0x5B8D ),
    MAKE_PAIR( 0x80AC, 0x75A3 ),
    MAKE_PAIR( 0x80CC, 0x810A ),
    MAKE_PAIR( 0x80EF, 0x8DE8 ),
    MAKE_PAIR( 0x8109, 0x8108 ),
    MAKE_PAIR( 0x8123, 0x5507 ),
    MAKE_PAIR( 0x815F, 0x81A3 ),
    MAKE_PAIR( 0x8166, 0x8133 ),
    MAKE_PAIR( 0x8193, 0x8178 ),
    MAKE_PAIR( 0x81B8, 0x9AC4 ),
    MAKE_PAIR( 0x81BD, 0x80C6 ),
    MAKE_PAIR( 0x81C8, 0x81D8 ),
    MAKE_PAIR( 0x81DF, 0x81D3 ),
    MAKE_PAIR( 0x81FA, 0x53F0 ),
    MAKE_PAIR( 0x8207, 0x4E0E ),
    MAKE_PAIR( 0x8209, 0x6319 ),
    MAKE_PAIR( 0x820A, 0x65E7 ),
    MAKE_PAIR( 0x820D, 0x820E ),
    MAKE_PAIR( 0x8216, 0x8217 ),
    MAKE_PAIR( 0x8218, 0x9928 ),
    MAKE_PAIR( 0x8229, 0x8239 ),
    MAKE_PAIR( 0x822E, 0x826B ),
    MAKE_PAIR( 0x8235, 0x67C1 ),
    MAKE_PAIR( 0x8277, 0x8276 ),
    MAKE_PAIR( 0x82C5, 0x5208 ),
    MAKE_PAIR( 0x8358, 0x5E84 ),
    MAKE_PAIR( 0x8373, 0x8C46 ),
    MAKE_PAIR( 0x838A, 0x5E84 ),
    MAKE_PAIR( 0x8393, 0x82FA ),
    MAKE_PAIR( 0x8396, 0x830E ),
    MAKE_PAIR( 0x83B5, 0x514E ),
    MAKE_PAIR( 0x83DF, 0x514E ),
    MAKE_PAIR( 0x83F4, 0x5EB5 ),
    MAKE_PAIR( 0x8420, 0x840C ),
    MAKE_PAIR( 0x842C, 0x4E07 ),
    MAKE_PAIR( 0x8462, 0x84CB ),
    MAKE_PAIR( 0x84AD, 0x82BB ),
    MAKE_PAIR( 0x854B, 0x854A ),
    MAKE_PAIR( 0x855A, 0x843C ),
    MAKE_PAIR( 0x8597, 0x5712 ),
    MAKE_PAIR( 0x85C1, 0x7A3F ),
    MAKE_PAIR( 0x85CF, 0x8535 ),
    MAKE_PAIR( 0x85DD, 0x82B8 ),
    MAKE_PAIR( 0x85E5, 0x85AC ),
    MAKE_PAIR( 0x85EA, 0x85AE ),
    MAKE_PAIR( 0x8602, 0x854A ),
    MAKE_PAIR( 0x8606, 0x82A6 ),
    MAKE_PAIR( 0x8613, 0x8607 ),
    MAKE_PAIR( 0x8617, 0x6A97 ),
    MAKE_PAIR( 0x862F, 0x76EA ),
    MAKE_PAIR( 0x8655, 0x51E6 ),
    MAKE_PAIR( 0x865F, 0x53F7 ),
    MAKE_PAIR( 0x8768, 0x8671 ),
    MAKE_PAIR( 0x87A2, 0x86CD ),
    MAKE_PAIR( 0x87C6, 0x87C7 ),
    MAKE_PAIR( 0x87D2, 0x880E ),
    MAKE_PAIR( 0x87F2, 0x866B ),
    MAKE_PAIR( 0x8805, 0x877F ),
    MAKE_PAIR( 0x880F, 0x87F9 ),
    MAKE_PAIR( 0x8823, 0x86CE ),
    MAKE_PAIR( 0x8827, 0x8839 ),
    MAKE_PAIR( 0x8836, 0x8695 ),
    MAKE_PAIR( 0x883B, 0x86EE ),
    MAKE_PAIR( 0x8842, 0x8844 ),
    MAKE_PAIR( 0x885E, 0x885B ),
    MAKE_PAIR( 0x88B5, 0x887D ),
    MAKE_PAIR( 0x88DD, 0x88C5 ),
    MAKE_PAIR( 0x88E1, 0x88CF ),
    MAKE_PAIR( 0x891D, 0x894C ),
    MAKE_PAIR( 0x8943, 0x8912 ),
    MAKE_PAIR( 0x894D, 0x96D1 ),
    MAKE_PAIR( 0x898A, 0x7F88 ),
    MAKE_PAIR( 0x89BA, 0x899A ),
    MAKE_PAIR( 0x89BD, 0x89A7 ),
    MAKE_PAIR( 0x89C0, 0x89B3 ),
    MAKE_PAIR( 0x89E7, 0x89E3 ),
    MAKE_PAIR( 0x89F8, 0x89E6 ),
    MAKE_PAIR( 0x8A00, 0x4E91 ),
    MAKE_PAIR( 0x8A3B, 0x6CE8 ),
    MAKE_PAIR( 0x8AE1, 0x8B1A ),
    MAKE_PAIR( 0x8AEB, 0x8ACC ),
    MAKE_PAIR( 0x8B0C, 0x6B4C ),
    MAKE_PAIR( 0x8B20, 0x8B21 ),
    MAKE_PAIR( 0x8B41, 0x5629 ),
    MAKE_PAIR( 0x8B49, 0x8A3C ),
    MAKE_PAIR( 0x8B5B, 0x8B56 ),
    MAKE_PAIR( 0x8B5F, 0x566A ),
    MAKE_PAIR( 0x8B6F, 0x8A33 ),
    MAKE_PAIR( 0x8B71, 0x5584 ),
    MAKE_PAIR( 0x8B7D, 0x8A89 ),
    MAKE_PAIR( 0x8B80, 0x8AAD ),
    MAKE_PAIR( 0x8B8A, 0x5909 ),
    MAKE_PAIR( 0x8B8E, 0x8B90 ),
    MAKE_PAIR( 0x8B93, 0x8B72 ),
    MAKE_PAIR( 0x8B9A, 0x8B83 ),
    MAKE_PAIR( 0x8C3F, 0x6E13 ),
    MAKE_PAIR( 0x8C4E, 0x7AEA ),
    MAKE_PAIR( 0x8C50, 0x8C4A ),
    MAKE_PAIR( 0x8C6B, 0x4E88 ),
    MAKE_PAIR( 0x8C6C, 0x732A ),
    MAKE_PAIR( 0x8C7A, 0x72B2 ),
    MAKE_PAIR( 0x8C7C, 0x8C94 ),
    MAKE_PAIR( 0x8C89, 0x72F8 ),
    MAKE_PAIR( 0x8C8D, 0x72F8 ),
    MAKE_PAIR( 0x8C8E, 0x730A ),
    MAKE_PAIR( 0x8C98, 0x734F ),
    MAKE_PAIR( 0x8CAD, 0x8CEA ),
    MAKE_PAIR( 0x8CAE, 0x4E8C ),
    MAKE_PAIR( 0x8CB3, 0x4E8C ),
    MAKE_PAIR( 0x8CCD, 0x81D3 ),
    MAKE_PAIR( 0x8CE3, 0x58F2 ),
    MAKE_PAIR( 0x8CE4, 0x8CCE ),
    MAKE_PAIR( 0x8D0A, 0x8CDB ),
    MAKE_PAIR( 0x8D13, 0x81D3 ),
    MAKE_PAIR( 0x8D71, 0x8D70 ),
    MAKE_PAIR( 0x8E08, 0x758E ),
    MAKE_PAIR( 0x8E10, 0x8DF5 ),
    MAKE_PAIR( 0x8E34, 0x8E0A ),
    MAKE_PAIR( 0x8E48, 0x8E0F ),
    MAKE_PAIR( 0x8E87, 0x58B8 ),
    MAKE_PAIR( 0x8EAA, 0x8E99 ),
    MAKE_PAIR( 0x8EB0, 0x4F53 ),
    MAKE_PAIR( 0x8EC6, 0x4F53 ),
    MAKE_PAIR( 0x8EE3, 0x8F5F ),
    MAKE_PAIR( 0x8F0C, 0x4E21 ),
    MAKE_PAIR( 0x8F15, 0x8EFD ),
    MAKE_PAIR( 0x8F19, 0x8F12 ),
    MAKE_PAIR( 0x8F1B, 0x4E21 ),
    MAKE_PAIR( 0x8F49, 0x8EE2 ),
    MAKE_PAIR( 0x8FA7, 0x5F01 ),
    MAKE_PAIR( 0x8FA8, 0x5F01 ),
    MAKE_PAIR( 0x8FAD, 0x8F9E ),
    MAKE_PAIR( 0x8FAF, 0x5F01 ),
    MAKE_PAIR( 0x8FEA, 0x5EF8 ),
    MAKE_PAIR( 0x8FEF, 0x9003 ),
    MAKE_PAIR( 0x8FF4, 0x5EFB ),
    MAKE_PAIR( 0x8FFA, 0x5EFC ),
    MAKE_PAIR( 0x900E, 0x9052 ),
    MAKE_PAIR( 0x9015, 0x5F84 ),
    MAKE_PAIR( 0x9023, 0x806F ),
    MAKE_PAIR( 0x9039, 0x9054 ),
    MAKE_PAIR( 0x9059, 0x9065 ),
    MAKE_PAIR( 0x905E, 0x9013 ),
    MAKE_PAIR( 0x9072, 0x9045 ),
    MAKE_PAIR( 0x9087, 0x8FE9 ),
    MAKE_PAIR( 0x9089, 0x8FBA ),
    MAKE_PAIR( 0x908A, 0x8FBA ),
    MAKE_PAIR( 0x90B1, 0x4E18 ),
    MAKE_PAIR( 0x9130, 0x96A3 ),
    MAKE_PAIR( 0x9189, 0x9154 ),
    MAKE_PAIR( 0x918B, 0x9162 ),
    MAKE_PAIR( 0x91AB, 0x533B ),
    MAKE_PAIR( 0x91BA, 0x718F ),
    MAKE_PAIR( 0x91C0, 0x91B8 ),
    MAKE_PAIR( 0x91CB, 0x91C8 ),
    MAKE_PAIR( 0x91E1, 0x91DC ),
    MAKE_PAIR( 0x91FC, 0x5263 ),
    MAKE_PAIR( 0x9214, 0x6284 ),
    MAKE_PAIR( 0x9229, 0x946A ),
    MAKE_PAIR( 0x922C, 0x9438 ),
    MAKE_PAIR( 0x9248, 0x91F6 ),
    MAKE_PAIR( 0x9264, 0x920E ),
    MAKE_PAIR( 0x9295, 0x9244 ),
    MAKE_PAIR( 0x92EA, 0x8217 ),
    MAKE_PAIR( 0x9322, 0x92AD ),
    MAKE_PAIR( 0x9394, 0x7194 ),
    MAKE_PAIR( 0x93AD, 0x93AE ),
    MAKE_PAIR( 0x941A, 0x930F ),
    MAKE_PAIR( 0x9421, 0x9244 ),
    MAKE_PAIR( 0x9435, 0x9244 ),
    MAKE_PAIR( 0x9444, 0x92F3 ),
    MAKE_PAIR( 0x9452, 0x9451 ),
    MAKE_PAIR( 0x945A, 0x947D ),
    MAKE_PAIR( 0x945B, 0x9271 ),
    MAKE_PAIR( 0x9587, 0x9589 ),
    MAKE_PAIR( 0x95A0, 0x958F ),
    MAKE_PAIR( 0x95DC, 0x95A2 ),
    MAKE_PAIR( 0x962A, 0x5742 ),
    MAKE_PAIR( 0x962F, 0x5740 ),
    MAKE_PAIR( 0x9644, 0x4ED8 ),
    MAKE_PAIR( 0x9670, 0x852D ),
    MAKE_PAIR( 0x9677, 0x9665 ),
    MAKE_PAIR( 0x96A8, 0x968F ),
    MAKE_PAIR( 0x96AA, 0x967A ),
    MAKE_PAIR( 0x96B1, 0x852D ),
    MAKE_PAIR( 0x96B8, 0x96B7 ),
    MAKE_PAIR( 0x96C6, 0x8F2F ),
    MAKE_PAIR( 0x96D9, 0x53CC ),
    MAKE_PAIR( 0x96DC, 0x96D1 ),
    MAKE_PAIR( 0x9738, 0x8987 ),
    MAKE_PAIR( 0x9748, 0x970A ),
    MAKE_PAIR( 0x975C, 0x9759 ),
    MAKE_PAIR( 0x976B, 0x976D ),
    MAKE_PAIR( 0x9771, 0x976D ),
    MAKE_PAIR( 0x97ED, 0x97EE ),
    MAKE_PAIR( 0x97F2, 0x9F4F ),
    MAKE_PAIR( 0x97F5, 0x97FB ),
    MAKE_PAIR( 0x9834, 0x7A4E ),
    MAKE_PAIR( 0x9838, 0x981A ),
    MAKE_PAIR( 0x984B, 0x816E ),
    MAKE_PAIR( 0x984F, 0x9854 ),
    MAKE_PAIR( 0x986F, 0x9855 ),
    MAKE_PAIR( 0x98B1, 0x53F0 ),
    MAKE_PAIR( 0x98C3, 0x98C4 ),
    MAKE_PAIR( 0x98DC, 0x7FFB ),
    MAKE_PAIR( 0x98EE, 0x98F2 ),
    MAKE_PAIR( 0x9918, 0x4F59 ),
    MAKE_PAIR( 0x991D, 0x98FE ),
    MAKE_PAIR( 0x9920, 0x9905 ),
    MAKE_PAIR( 0x99C8, 0x99C6 ),
    MAKE_PAIR( 0x99F2, 0x99B4 ),
    MAKE_PAIR( 0x9A37, 0x9A12 ),
    MAKE_PAIR( 0x9A45, 0x99C6 ),
    MAKE_PAIR( 0x9A57, 0x9A13 ),
    MAKE_PAIR( 0x9A5B, 0x99C5 ),
    MAKE_PAIR( 0x9AD3, 0x9AC4 ),
    MAKE_PAIR( 0x9AD4, 0x4F53 ),
    MAKE_PAIR( 0x9AEE, 0x9AEA ),
    MAKE_PAIR( 0x9AF4, 0x5F7F ),
    MAKE_PAIR( 0x9B27, 0x9599 ),
    MAKE_PAIR( 0x9B28, 0x95A7 ),
    MAKE_PAIR( 0x9B2A, 0x95D8 ),
    MAKE_PAIR( 0x9B31, 0x6B1D ),
    MAKE_PAIR( 0x9B3B, 0x7CA5 ),
    MAKE_PAIR( 0x9C1B, 0x9C2E ),
    MAKE_PAIR( 0x9C3A, 0x9BF5 ),
    MAKE_PAIR( 0x9CEB, 0x96C1 ),
    MAKE_PAIR( 0x9CEC, 0x9CE7 ),
    MAKE_PAIR( 0x9D08, 0x96C1 ),
    MAKE_PAIR( 0x9D44, 0x9D1F ),
    MAKE_PAIR( 0x9D5E, 0x9D5D ),
    MAKE_PAIR( 0x9DAB, 0x9D87 ),
    MAKE_PAIR( 0x9DAF, 0x9D2C ),
    MAKE_PAIR( 0x9DC4, 0x9D8F ),
    MAKE_PAIR( 0x9DCF, 0x9DC6 ),
    MAKE_PAIR( 0x9E7D, 0x5869 ),
    MAKE_PAIR( 0x9EA5, 0x9EA6 ),
    MAKE_PAIR( 0x9EAA, 0x9EBA ),
    MAKE_PAIR( 0x9EB8, 0x9EA9 ),
    MAKE_PAIR( 0x9ED8, 0x9ED9 ),
    MAKE_PAIR( 0x9EDE, 0x70B9 ),
    MAKE_PAIR( 0x9EE8, 0x515A ),
    MAKE_PAIR( 0x9F07, 0x9C32 ),
    MAKE_PAIR( 0x9F21, 0x9F20 ),
    MAKE_PAIR( 0x9F4A, 0x658E ),
    MAKE_PAIR( 0x9F4B, 0x658E ),
    MAKE_PAIR( 0x9F52, 0x6B6F ),
    MAKE_PAIR( 0x9F61, 0x9F62 ),
    MAKE_PAIR( 0x9F67, 0x56D3 ),
    MAKE_PAIR( 0x9F8D, 0x7ADC ),
    MAKE_PAIR( 0x9F9C, 0x4E80 ),
    MAKE_PAIR( 0x9F9D, 0x7A50 ),
    MAKE_PAIR( 0xFEFF, 0x4E9C )
};

ignoreTraditionalKanji_ja_JP::ignoreTraditionalKanji_ja_JP()
{
        static oneToOneMapping _table(traditionalKanji2updateKanji, sizeof(traditionalKanji2updateKanji));
        func = (TransFunc)0;
        table = &_table;
        map = 0;
        transliterationName = "ignoreTraditionalKanji_ja_JP";
        implementationName = "com.sun.star.i18n.Transliteration.ignoreTraditionalKanji_ja_JP";
}

} } } }
