/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/


#ifndef _I18N_BREAKITERATOR_UNICODE_HXX_
#define _I18N_BREAKITERATOR_UNICODE_HXX_

#include <breakiteratorImpl.hxx>

#include "warnings_guard_unicode_brkiter.h"

namespace com { namespace sun { namespace star { namespace i18n {

#define LOAD_CHARACTER_BREAKITERATOR    0
#define LOAD_WORD_BREAKITERATOR         1
#define LOAD_SENTENCE_BREAKITERATOR     2
#define LOAD_LINE_BREAKITERATOR         3

//	----------------------------------------------------
//	class BreakIterator_Unicode
//	----------------------------------------------------
class BreakIterator_Unicode : public BreakIteratorImpl
{
public:
	BreakIterator_Unicode();
	~BreakIterator_Unicode();

	virtual sal_Int32 SAL_CALL previousCharacters( const rtl::OUString& Text, sal_Int32 nStartPos, 
		const com::sun::star::lang::Locale& nLocale, sal_Int16 nCharacterIteratorMode, sal_Int32 nCount, 
		sal_Int32& nDone ) throw(com::sun::star::uno::RuntimeException);
	virtual sal_Int32 SAL_CALL nextCharacters( const rtl::OUString& Text, sal_Int32 nStartPos, 
		const com::sun::star::lang::Locale& rLocale, sal_Int16 nCharacterIteratorMode, sal_Int32 nCount, 
		sal_Int32& nDone ) throw(com::sun::star::uno::RuntimeException);

	virtual Boundary SAL_CALL previousWord( const rtl::OUString& Text, sal_Int32 nStartPos, 
		const com::sun::star::lang::Locale& nLocale, sal_Int16 WordType) throw(com::sun::star::uno::RuntimeException);
	virtual Boundary SAL_CALL nextWord( const rtl::OUString& Text, sal_Int32 nStartPos, 
		const com::sun::star::lang::Locale& nLocale, sal_Int16 WordType) throw(com::sun::star::uno::RuntimeException);
	virtual Boundary SAL_CALL getWordBoundary( const rtl::OUString& Text, sal_Int32 nPos, 
		const com::sun::star::lang::Locale& nLocale, sal_Int16 WordType, sal_Bool bDirection ) 
		throw(com::sun::star::uno::RuntimeException);

	virtual sal_Int32 SAL_CALL beginOfSentence( const rtl::OUString& Text, sal_Int32 nStartPos, 
		const com::sun::star::lang::Locale& nLocale ) throw(com::sun::star::uno::RuntimeException);
	virtual sal_Int32 SAL_CALL endOfSentence( const rtl::OUString& Text, sal_Int32 nStartPos, 
		const com::sun::star::lang::Locale& nLocale ) throw(com::sun::star::uno::RuntimeException);

	virtual LineBreakResults SAL_CALL getLineBreak( const rtl::OUString& Text, sal_Int32 nStartPos, 
		const com::sun::star::lang::Locale& nLocale, sal_Int32 nMinBreakPos, 
		const LineBreakHyphenationOptions& hOptions, const LineBreakUserOptions& bOptions ) 
		throw(com::sun::star::uno::RuntimeException);

	//XServiceInfo
	virtual rtl::OUString SAL_CALL getImplementationName() throw( com::sun::star::uno::RuntimeException );
	virtual sal_Bool SAL_CALL supportsService(const rtl::OUString& ServiceName) 
		throw( com::sun::star::uno::RuntimeException );
	virtual com::sun::star::uno::Sequence< rtl::OUString > SAL_CALL getSupportedServiceNames() 
		throw( com::sun::star::uno::RuntimeException );

protected:
	const sal_Char *cBreakIterator, *wordRule, *lineRule;
	Boundary result; // for word break iterator

    struct BI_Data {
        UnicodeString aICUText;
        icu::BreakIterator *aBreakIterator;
        
        BI_Data() : aICUText(), aBreakIterator(NULL) {}
    } character, word, sentence, line, *icuBI; 

    com::sun::star::lang::Locale aLocale;
    sal_Int16 aBreakType, aWordType;

    void SAL_CALL loadICUBreakIterator(const com::sun::star::lang::Locale& rLocale, 
        sal_Int16 rBreakType, sal_Int16 rWordType, const sal_Char* name, const rtl::OUString& rText) throw(com::sun::star::uno::RuntimeException);
};

} } } } 

#endif
