/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/


#ifndef __BREAKITERATOR_CTL_HXX__
#define __BREAKITERATOR_CTL_HXX__

#include <breakiterator_unicode.hxx>
#include <xdictionary.hxx>

namespace com { namespace sun { namespace star { namespace i18n {

//	----------------------------------------------------
//	class BreakIterator_CTL
//	----------------------------------------------------
class BreakIterator_CTL : public BreakIterator_Unicode
{
public:
	BreakIterator_CTL();
	~BreakIterator_CTL();
	virtual sal_Int32 SAL_CALL previousCharacters(const rtl::OUString& text, sal_Int32 start,
		const lang::Locale& nLocale, sal_Int16 nCharacterIteratorMode, sal_Int32 count,
		sal_Int32& nDone) throw(com::sun::star::uno::RuntimeException);
	virtual sal_Int32 SAL_CALL nextCharacters(const rtl::OUString& text, sal_Int32 start,
		const lang::Locale& rLocale, sal_Int16 nCharacterIteratorMode, sal_Int32 count,
		sal_Int32& nDone) throw(com::sun::star::uno::RuntimeException);
	virtual LineBreakResults SAL_CALL getLineBreak( const rtl::OUString& Text, sal_Int32 nStartPos, 
		const com::sun::star::lang::Locale& nLocale, sal_Int32 nMinBreakPos, 
		const LineBreakHyphenationOptions& hOptions, const LineBreakUserOptions& bOptions ) 
		throw(com::sun::star::uno::RuntimeException);
protected:
	rtl::OUString cachedText; // for cell index
	sal_Int32* nextCellIndex;
	sal_Int32* previousCellIndex;
	sal_Int32 cellIndexSize;
    
    virtual void SAL_CALL makeIndex(const rtl::OUString& text, sal_Int32 pos) throw(com::sun::star::uno::RuntimeException);
};

} } } } 

#endif
