/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



#ifndef __FRAMEWORK_THREADHELP_INONCOPYABLE_H_
#define __FRAMEWORK_THREADHELP_INONCOPYABLE_H_

//_________________________________________________________________________________________________________________
//	my own includes
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	other includes
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

namespace framework{

//_________________________________________________________________________________________________________________
//	const
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	declarations
//_________________________________________________________________________________________________________________

/*-************************************************************************************************************//**
	@descr			Use this as one of your base classes to disable
					all possiblities to copy or assign one object to another one!
					We declare neccessary functions private to do so.
*//*-*************************************************************************************************************/
class INonCopyable
{
	public:

        INonCopyable() {}

	private:

        INonCopyable            ( const INonCopyable& rCopy );
        INonCopyable& operator= ( const INonCopyable& rCopy );

};      //  class INonCopyable

}		//	namespace framework

#endif	//	#ifndef __FRAMEWORK_THREADHELP_INONCOPYABLE_H_
