/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



#include <osl/interlck.h>
#include <osl/mutex.hxx>
#include <platform.h>

class OleComponent;
class OleWrapperAdviseSink : public IAdviseSink
{
protected:
	osl::Mutex m_aMutex;
	oslInterlockedCount m_nRefCount;
	OleComponent* m_pOleComp;

public:
	OleWrapperAdviseSink( OleComponent* pOleComp );
	OleWrapperAdviseSink(void);
	virtual ~OleWrapperAdviseSink();

	void disconnectOleComponent();
	STDMETHODIMP QueryInterface(REFIID, void**);
	STDMETHODIMP_(ULONG) AddRef(void);
	STDMETHODIMP_(ULONG) Release(void);

	STDMETHODIMP_(void)  OnDataChange(LPFORMATETC, LPSTGMEDIUM);
	STDMETHODIMP_(void)  OnViewChange(DWORD, LONG);
	STDMETHODIMP_(void)  OnRename(LPMONIKER);
	STDMETHODIMP_(void)  OnSave(void);
	STDMETHODIMP_(void)  OnClose(void);
};

