/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/


#ifndef _SVX_HYZNITEM_HXX
#define _SVX_HYZNITEM_HXX

// include ---------------------------------------------------------------

#include <svl/poolitem.hxx>
#include <editeng/editengdllapi.h>

class SvXMLUnitConverter;
namespace rtl
{
	class OUString;
}

// class SvxHyphenZoneItem -----------------------------------------------

/*
[Beschreibung]
Dieses Item beschreibt ein Silbentrennungsattribut (Automatisch?, Anzahl der
Zeichen am Zeilenende und -anfang).
*/

class EDITENG_DLLPUBLIC SvxHyphenZoneItem : public SfxPoolItem
{
	sal_Bool bHyphen:  1;
	sal_Bool bPageEnd: 1;
	sal_uInt8 nMinLead;
	sal_uInt8 nMinTrail;
	sal_uInt8 nMaxHyphens;

	friend SvStream & operator<<( SvStream & aS, SvxHyphenZoneItem & );

public:
	TYPEINFO();

    SvxHyphenZoneItem( const sal_Bool bHyph /*= sal_False*/,
                       const sal_uInt16 nId  );

	// "pure virtual Methoden" vom SfxPoolItem
	virtual int 			 operator==( const SfxPoolItem& ) const;
	virtual	sal_Bool        	 QueryValue( com::sun::star::uno::Any& rVal, sal_uInt8 nMemberId = 0 ) const;
	virtual	sal_Bool			 PutValue( const com::sun::star::uno::Any& rVal, sal_uInt8 nMemberId = 0 );

	virtual SfxItemPresentation GetPresentation( SfxItemPresentation ePres,
									SfxMapUnit eCoreMetric,
									SfxMapUnit ePresMetric,
                                    String &rText, const IntlWrapper * = 0 ) const;

	virtual SfxPoolItem*	 Clone( SfxItemPool *pPool = 0 ) const;
	virtual SfxPoolItem*	 Create(SvStream &, sal_uInt16) const;
	virtual SvStream&		 Store(SvStream &, sal_uInt16 nItemVersion ) const;

	inline void SetHyphen( const sal_Bool bNew ) { bHyphen = bNew; }
	inline sal_Bool IsHyphen() const { return bHyphen; }

	inline void SetPageEnd( const sal_Bool bNew ) { bPageEnd = bNew; }
	inline sal_Bool IsPageEnd() const { return bPageEnd; }

	inline sal_uInt8 &GetMinLead() { return nMinLead; }
	inline sal_uInt8 GetMinLead() const { return nMinLead; }

	inline sal_uInt8 &GetMinTrail() { return nMinTrail; }
	inline sal_uInt8 GetMinTrail() const { return nMinTrail; }

	inline sal_uInt8 &GetMaxHyphens() { return nMaxHyphens; }
	inline sal_uInt8 GetMaxHyphens() const { return nMaxHyphens; }

	inline SvxHyphenZoneItem &operator=( const SvxHyphenZoneItem &rNew )
	{
		bHyphen = rNew.IsHyphen();
		bPageEnd = rNew.IsPageEnd();
		nMinLead = rNew.GetMinLead();
		nMinTrail = rNew.GetMinTrail();
		nMaxHyphens = rNew.GetMaxHyphens();
		return *this;
	}
};

#endif

