/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/


#ifndef _SVX_FRMDIRITEM_HXX
#define _SVX_FRMDIRITEM_HXX

// include ---------------------------------------------------------------

#include <svl/intitem.hxx>
#include <editeng/frmdir.hxx>
#include <editeng/editengdllapi.h>

// class SvxFrameDirectionItem ----------------------------------------------

/* [Description]

	This item defines a frame direction, which place the content inside
	a frame. It exist different kind of directions which are used to the
	layout text for Western, CJK and CTL languages.
*/

class EDITENG_DLLPUBLIC SvxFrameDirectionItem : public SfxUInt16Item
{
public:
	TYPEINFO();

    SvxFrameDirectionItem( sal_uInt16 nWhich  );
    SvxFrameDirectionItem( SvxFrameDirection nValue /*= FRMDIR_HORI_LEFT_TOP*/,
                            sal_uInt16 nWhich  );
	virtual ~SvxFrameDirectionItem();

	virtual SfxPoolItem*	Clone( SfxItemPool *pPool = 0 ) const;
	virtual SfxPoolItem*	Create(SvStream &, sal_uInt16) const;
	virtual SvStream& 		Store(SvStream & rStrm, sal_uInt16 nIVer) const;
	virtual sal_uInt16			GetVersion( sal_uInt16 nFileVersion ) const;
	virtual int 			operator==( const SfxPoolItem& ) const;

	virtual SfxItemPresentation GetPresentation( SfxItemPresentation ePres,
									SfxMapUnit eCoreMetric,
									SfxMapUnit ePresMetric,
									String &rText,
                                    const IntlWrapper * = 0 ) const;

	virtual sal_Bool PutValue( const com::sun::star::uno::Any& rVal,
									sal_uInt8 nMemberId );
	virtual sal_Bool QueryValue( com::sun::star::uno::Any& rVal,
								sal_uInt8 nMemberId ) const;

	inline SvxFrameDirectionItem& operator=( const SvxFrameDirectionItem& rItem )
	{
		SetValue( rItem.GetValue() );
		return *this;
	}
};

#endif // #ifndef _SVX_FRMDIRITEM_HXX

