/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/


#ifndef _SVX_FLSTITEM_HXX
#define _SVX_FLSTITEM_HXX

// include ---------------------------------------------------------------

#include <svl/poolitem.hxx>
#include <rtl/ustring.hxx>
#include <com/sun/star/uno/Sequence.h>
#include "editeng/editengdllapi.h"

// class SvxFontListItem -------------------------------------------------

class FontList;

/*
	[Beschreibung]

	Dieses Item dient als Transport-Medium fuer eine FontListe.
	Die Fontliste wird nicht kopiert und nicht geloescht!
*/

class EDITENG_DLLPUBLIC SvxFontListItem : public SfxPoolItem
{
private:
	const FontList*                                 pFontList;
	com::sun::star::uno::Sequence< rtl::OUString >  aFontNameSeq;

public:
	TYPEINFO();

	SvxFontListItem( const FontList* pFontLst,
                     const sal_uInt16 nId  );
	SvxFontListItem( const SvxFontListItem& rItem );

	virtual int				operator==( const SfxPoolItem& ) const;
	virtual SfxPoolItem*	Clone( SfxItemPool *pPool = 0 ) const;

	virtual	sal_Bool        QueryValue( com::sun::star::uno::Any& rVal, sal_uInt8 nMemberId = 0 ) const;

	virtual SfxItemPresentation GetPresentation( SfxItemPresentation ePres,
									SfxMapUnit eCoreMetric,
									SfxMapUnit ePresMetric,
                                    String &rText, const IntlWrapper * = 0 ) const;

	const FontList*			GetFontList() const { return pFontList; }
};




#endif


