/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/


#ifndef _SVX_BRKITEM_HXX
#define _SVX_BRKITEM_HXX

// include ---------------------------------------------------------------

#include <svl/eitem.hxx>
#include <editeng/svxenum.hxx>
#include <editeng/editengdllapi.h>

namespace rtl
{
	class OUString;
}

// class SvxFmtBreakItem -------------------------------------------------

/*
	[Beschreibung]
	Dieses Item beschreibt ein Umbruch-Attribut
	Automatisch?, Seiten- oder Spaltenumbruch, davor oder danach?
*/
#define	FMTBREAK_NOAUTO	((sal_uInt16)0x0001)

class EDITENG_DLLPUBLIC SvxFmtBreakItem : public SfxEnumItem
{
public:
	TYPEINFO();

    inline SvxFmtBreakItem( const SvxBreak eBrk /*= SVX_BREAK_NONE*/,
                            const sal_uInt16 nWhich );
	inline SvxFmtBreakItem( const SvxFmtBreakItem& rBreak );
	inline SvxFmtBreakItem& operator=( const SvxFmtBreakItem& rCpy );

	// "pure virtual Methoden" vom SfxPoolItem
	virtual int 			 operator==( const SfxPoolItem& ) const;
	virtual	sal_Bool        	 QueryValue( com::sun::star::uno::Any& rVal, sal_uInt8 nMemberId = 0 ) const;
	virtual	sal_Bool			 PutValue( const com::sun::star::uno::Any& rVal, sal_uInt8 nMemberId = 0 );

	virtual SfxItemPresentation GetPresentation( SfxItemPresentation ePres,
									SfxMapUnit eCoreMetric,
									SfxMapUnit ePresMetric,
                                    String &rText, const IntlWrapper * = 0 ) const;
	virtual String			 GetValueTextByPos( sal_uInt16 nPos ) const;

	virtual SfxPoolItem*	 Clone( SfxItemPool *pPool = 0 ) const;
	virtual SvStream&		 Store( SvStream& , sal_uInt16 nItemVersion ) const;
	virtual sal_uInt16			 GetVersion( sal_uInt16 nFileVersion ) const;
	virtual SfxPoolItem*	 Create( SvStream&, sal_uInt16 ) const;
	virtual sal_uInt16			 GetValueCount() const;

	// MS VC4.0 kommt durcheinander
	void			 SetValue( sal_uInt16 nNewVal )
								{SfxEnumItem::SetValue(nNewVal); }
	SvxBreak			 GetBreak() const { return SvxBreak( GetValue() ); }
	void					 SetBreak( const SvxBreak eNew )
								{ SetValue( (sal_uInt16)eNew ); }
};


inline SvxFmtBreakItem::SvxFmtBreakItem( const SvxBreak eBreak,
                                         const sal_uInt16 _nWhich ) :
    SfxEnumItem( _nWhich, (sal_uInt16)eBreak )
{}

inline SvxFmtBreakItem::SvxFmtBreakItem( const SvxFmtBreakItem& rBreak ) :
	SfxEnumItem( rBreak )
{}

inline SvxFmtBreakItem& SvxFmtBreakItem::operator=(
	const SvxFmtBreakItem& rBreak )
{
	SetValue( rBreak.GetValue() );
	return *this;
}

#endif

