/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_drawinglayer.hxx"

#include <drawinglayer/processor3d/baseprocessor3d.hxx>

//////////////////////////////////////////////////////////////////////////////

using namespace com::sun::star;

//////////////////////////////////////////////////////////////////////////////

namespace drawinglayer
{
	namespace processor3d
	{
		void BaseProcessor3D::processBasePrimitive3D(const primitive3d::BasePrimitive3D& /*rCandidate*/)
		{
		}

		BaseProcessor3D::BaseProcessor3D(const geometry::ViewInformation3D& rViewInformation)
		:	maViewInformation3D(rViewInformation)
		{
		}

		BaseProcessor3D::~BaseProcessor3D()
		{
		}

		void BaseProcessor3D::process(const primitive3d::Primitive3DSequence& rSource)
		{
			if(rSource.hasElements())
			{
				const sal_Int32 nCount(rSource.getLength());
			
				for(sal_Int32 a(0L); a < nCount; a++)
				{
					// get reference
					const primitive3d::Primitive3DReference xReference(rSource[a]);

					if(xReference.is())
					{
						// try to cast to BasePrimitive3D implementation
						const primitive3d::BasePrimitive3D* pBasePrimitive = dynamic_cast< const primitive3d::BasePrimitive3D* >(xReference.get());

						if(pBasePrimitive)
						{
							processBasePrimitive3D(*pBasePrimitive);
						}
						else
						{
							// unknown implementation, use UNO API call instead and process recursively
							const uno::Sequence< beans::PropertyValue >& rViewParameters(getViewInformation3D().getViewInformationSequence());
							process(xReference->getDecomposition(rViewParameters));
						}
					}
				}
			}
		}
	} // end of namespace processor3d
} // end of namespace drawinglayer

//////////////////////////////////////////////////////////////////////////////

namespace drawinglayer
{
	namespace processor3d
	{
		CollectingProcessor3D::CollectingProcessor3D(const geometry::ViewInformation3D& rViewInformation)
		:	BaseProcessor3D(rViewInformation),
			maPrimitive3DSequence()
		{
		}

		CollectingProcessor3D::~CollectingProcessor3D()
		{
		}

		void CollectingProcessor3D::process(const primitive3d::Primitive3DSequence& rSource)
		{
			// accept everything
			primitive3d::appendPrimitive3DSequenceToPrimitive3DSequence(maPrimitive3DSequence, rSource);
		}
	} // end of namespace processor3d
} // end of namespace drawinglayer

//////////////////////////////////////////////////////////////////////////////
// eof
