/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_drawinglayer.hxx"

#include <drawinglayer/processor2d/linegeometryextractor2d.hxx>
#include <drawinglayer/primitive2d/drawinglayer_primitivetypes2d.hxx>
#include <drawinglayer/primitive2d/polygonprimitive2d.hxx>
#include <drawinglayer/primitive2d/polypolygonprimitive2d.hxx>
#include <drawinglayer/primitive2d/transformprimitive2d.hxx>

//////////////////////////////////////////////////////////////////////////////

using namespace com::sun::star;

//////////////////////////////////////////////////////////////////////////////

namespace drawinglayer
{
	namespace processor2d
	{
		LineGeometryExtractor2D::LineGeometryExtractor2D(const geometry::ViewInformation2D& rViewInformation)
		:	BaseProcessor2D(rViewInformation),
			maExtractedHairlines(),
			maExtractedLineFills(),
            mbInLineGeometry(false)
		{
		}

		LineGeometryExtractor2D::~LineGeometryExtractor2D()
		{
		}

		void LineGeometryExtractor2D::processBasePrimitive2D(const primitive2d::BasePrimitive2D& rCandidate)
		{
			switch(rCandidate.getPrimitive2DID())
			{
				case PRIMITIVE2D_ID_POLYGONSTROKEPRIMITIVE2D :
				case PRIMITIVE2D_ID_POLYGONSTROKEARROWPRIMITIVE2D :
                {
                    // enter a line geometry group (with or without LineEnds)
                    bool bOldState(mbInLineGeometry);
                    mbInLineGeometry = true;
					process(rCandidate.get2DDecomposition(getViewInformation2D()));
                    mbInLineGeometry = bOldState;
                    break;
                }
				case PRIMITIVE2D_ID_POLYGONHAIRLINEPRIMITIVE2D :
				{
                    if(mbInLineGeometry)
                    {
					    // extract hairline line geometry in world coordinates
					    const primitive2d::PolygonHairlinePrimitive2D& rPolygonCandidate(static_cast< const primitive2d::PolygonHairlinePrimitive2D& >(rCandidate));
					    basegfx::B2DPolygon aLocalPolygon(rPolygonCandidate.getB2DPolygon());
					    aLocalPolygon.transform(getViewInformation2D().getObjectTransformation());
                        maExtractedHairlines.push_back(aLocalPolygon);
                    }
					break;
				}
				case PRIMITIVE2D_ID_POLYPOLYGONCOLORPRIMITIVE2D :
				{
                    if(mbInLineGeometry)
                    {
					    // extract filled line geometry (line with width)
					    const primitive2d::PolyPolygonColorPrimitive2D& rPolygonCandidate(static_cast< const primitive2d::PolyPolygonColorPrimitive2D& >(rCandidate));
					    basegfx::B2DPolyPolygon aLocalPolyPolygon(rPolygonCandidate.getB2DPolyPolygon());
					    aLocalPolyPolygon.transform(getViewInformation2D().getObjectTransformation());
					    maExtractedLineFills.push_back(aLocalPolyPolygon);
                    }
					break;
				}
				case PRIMITIVE2D_ID_TRANSFORMPRIMITIVE2D :
				{
					// remember current transformation and ViewInformation
					const primitive2d::TransformPrimitive2D& rTransformCandidate(static_cast< const primitive2d::TransformPrimitive2D& >(rCandidate));
					const geometry::ViewInformation2D aLastViewInformation2D(getViewInformation2D());

					// create new transformations for CurrentTransformation and for local ViewInformation2D
					const geometry::ViewInformation2D aViewInformation2D(
						getViewInformation2D().getObjectTransformation() * rTransformCandidate.getTransformation(), 
						getViewInformation2D().getViewTransformation(), 
						getViewInformation2D().getViewport(),
						getViewInformation2D().getVisualizedPage(),
						getViewInformation2D().getViewTime(),
						getViewInformation2D().getExtendedInformationSequence());
					updateViewInformation(aViewInformation2D);

					// proccess content
					process(rTransformCandidate.getChildren());

					// restore transformations
					updateViewInformation(aLastViewInformation2D);

					break;
				}
				case PRIMITIVE2D_ID_SCENEPRIMITIVE2D :
                case PRIMITIVE2D_ID_WRONGSPELLPRIMITIVE2D :
				case PRIMITIVE2D_ID_MARKERARRAYPRIMITIVE2D :
				case PRIMITIVE2D_ID_POINTARRAYPRIMITIVE2D :
				case PRIMITIVE2D_ID_BITMAPPRIMITIVE2D :
				case PRIMITIVE2D_ID_METAFILEPRIMITIVE2D :
				case PRIMITIVE2D_ID_MASKPRIMITIVE2D :
                {
					// ignorable primitives
					break;
				}
				default :
				{
					// process recursively
					process(rCandidate.get2DDecomposition(getViewInformation2D()));
					break;
				}
			}
		}
	} // end of namespace processor2d
} // end of namespace drawinglayer

//////////////////////////////////////////////////////////////////////////////
// eof
