/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_drawinglayer.hxx"

#include <drawinglayer/processor2d/baseprocessor2d.hxx>

//////////////////////////////////////////////////////////////////////////////

using namespace com::sun::star;

//////////////////////////////////////////////////////////////////////////////

namespace drawinglayer
{
	namespace processor2d
	{
		void BaseProcessor2D::processBasePrimitive2D(const primitive2d::BasePrimitive2D& /*rCandidate*/)
		{
		}

		BaseProcessor2D::BaseProcessor2D(const geometry::ViewInformation2D& rViewInformation)
		:	maViewInformation2D(rViewInformation)
		{
		}

		BaseProcessor2D::~BaseProcessor2D()
		{
		}

		void BaseProcessor2D::process(const primitive2d::Primitive2DSequence& rSource)
		{
			if(rSource.hasElements())
			{
				const sal_Int32 nCount(rSource.getLength());

				for(sal_Int32 a(0L); a < nCount; a++)
				{
					// get reference
					const primitive2d::Primitive2DReference xReference(rSource[a]);

					if(xReference.is())
					{
						// try to cast to BasePrimitive2D implementation
						const primitive2d::BasePrimitive2D* pBasePrimitive = dynamic_cast< const primitive2d::BasePrimitive2D* >(xReference.get());

						if(pBasePrimitive)
						{
							// it is a BasePrimitive2D implementation, use local processor
							processBasePrimitive2D(*pBasePrimitive);
						}
						else
						{
							// unknown implementation, use UNO API call instead and process recursively
							const uno::Sequence< beans::PropertyValue >& rViewParameters(getViewInformation2D().getViewInformationSequence());
							process(xReference->getDecomposition(rViewParameters));
						}
					}
				}
			}
		}
	} // end of namespace processor2d
} // end of namespace drawinglayer

//////////////////////////////////////////////////////////////////////////////
// eof
