/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_drawinglayer.hxx"

#include <drawinglayer/primitive3d/shadowprimitive3d.hxx>
#include <drawinglayer/primitive3d/drawinglayer_primitivetypes3d.hxx>

//////////////////////////////////////////////////////////////////////////////

using namespace com::sun::star;

//////////////////////////////////////////////////////////////////////////////

namespace drawinglayer
{
	namespace primitive3d
	{
		ShadowPrimitive3D::ShadowPrimitive3D(
			const basegfx::B2DHomMatrix& rShadowTransform, 
			const basegfx::BColor& rShadowColor, 
			double fShadowTransparence, 
			bool bShadow3D, 
			const Primitive3DSequence& rChildren)
		:	GroupPrimitive3D(rChildren),
			maShadowTransform(rShadowTransform),
			maShadowColor(rShadowColor),
			mfShadowTransparence(fShadowTransparence),
			mbShadow3D(bShadow3D)
		{
		}

		bool ShadowPrimitive3D::operator==(const BasePrimitive3D& rPrimitive) const
		{
			if(GroupPrimitive3D::operator==(rPrimitive))
			{
				const ShadowPrimitive3D& rCompare = (ShadowPrimitive3D&)rPrimitive;

				return (getShadowTransform() == rCompare.getShadowTransform()
					&& getShadowColor() == rCompare.getShadowColor()
					&& getShadowTransparence() == rCompare.getShadowTransparence()
					&& getShadow3D() == rCompare.getShadow3D());
			}

			return false;
		}

		// provide unique ID
		ImplPrimitrive3DIDBlock(ShadowPrimitive3D, PRIMITIVE3D_ID_SHADOWPRIMITIVE3D)

	} // end of namespace primitive3d
} // end of namespace drawinglayer

//////////////////////////////////////////////////////////////////////////////
// eof
