/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



#ifndef INCLUDED_DRAWINGLAYER_PRIMITIVE3D_SDRDECOMPOSITIONTOOLS3D_HXX
#define INCLUDED_DRAWINGLAYER_PRIMITIVE3D_SDRDECOMPOSITIONTOOLS3D_HXX

#include <drawinglayer/drawinglayerdllapi.h>
#include <drawinglayer/primitive3d/baseprimitive3d.hxx>
#include <com/sun/star/drawing/TextureProjectionMode.hpp>
#include <vector>

//////////////////////////////////////////////////////////////////////////////
// predefines

namespace basegfx {
	class B3DPolygon;
	class B3DPolyPolygon;
	class B3DHomMatrix;
	class B2DVector;
}

namespace drawinglayer { namespace attribute {
	class SdrLineAttribute;
	class SdrFillAttribute;
	class Sdr3DObjectAttribute;
	class FillGradientAttribute;
	class SdrShadowAttribute;
}}

//////////////////////////////////////////////////////////////////////////////

namespace drawinglayer
{
	namespace primitive3d
	{
		// #i98295#
		basegfx::B3DRange getRangeFrom3DGeometry(::std::vector< basegfx::B3DPolyPolygon >& rFill);
		void applyNormalsKindSphereTo3DGeometry(::std::vector< basegfx::B3DPolyPolygon >& rFill, const basegfx::B3DRange& rRange);
		void applyNormalsKindFlatTo3DGeometry(::std::vector< basegfx::B3DPolyPolygon >& rFill);
		void applyNormalsInvertTo3DGeometry(::std::vector< basegfx::B3DPolyPolygon >& rFill);
		
		// #i98314#
		void applyTextureTo3DGeometry(
			::com::sun::star::drawing::TextureProjectionMode eModeX,
			::com::sun::star::drawing::TextureProjectionMode eModeY,
			::std::vector< basegfx::B3DPolyPolygon >& rFill,
			const basegfx::B3DRange& rRange,
			const basegfx::B2DVector& rTextureSize);

		Primitive3DSequence create3DPolyPolygonLinePrimitives(
			const basegfx::B3DPolyPolygon& rUnitPolyPolygon, 
			const basegfx::B3DHomMatrix& rObjectTransform,
			const attribute::SdrLineAttribute& rLine);

		Primitive3DSequence create3DPolyPolygonFillPrimitives(
			const ::std::vector< basegfx::B3DPolyPolygon >& r3DPolyPolygonVector,
			const basegfx::B3DHomMatrix& rObjectTransform,
			const basegfx::B2DVector& rTextureSize,
			const attribute::Sdr3DObjectAttribute& aSdr3DObjectAttribute,
			const attribute::SdrFillAttribute& rFill,
			const attribute::FillGradientAttribute& rFillGradient);

		Primitive3DSequence createShadowPrimitive3D(
			const Primitive3DSequence& rSource,
			const attribute::SdrShadowAttribute& rShadow,
			bool bShadow3D);

        Primitive3DSequence createHiddenGeometryPrimitives3D(
			const ::std::vector< basegfx::B3DPolyPolygon >& r3DPolyPolygonVector,
			const basegfx::B3DHomMatrix& rObjectTransform,
			const basegfx::B2DVector& rTextureSize,
			const attribute::Sdr3DObjectAttribute& aSdr3DObjectAttribute);

	} // end of namespace primitive3d
} // end of namespace drawinglayer

//////////////////////////////////////////////////////////////////////////////

#endif //_DRAWINGLAYER_PRIMITIVE3D_SDRDECOMPOSITIONTOOLS3D_HXX

// eof
