/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/

#ifndef INCLUDED_DRAWINGLAYER_ATTRIBUTE_SDRFILLATTRIBUTE_HXX
#define INCLUDED_DRAWINGLAYER_ATTRIBUTE_SDRFILLATTRIBUTE_HXX

#include <drawinglayer/drawinglayerdllapi.h>
//////////////////////////////////////////////////////////////////////////////
// predefines

namespace basegfx {
    class BColor;
}

namespace drawinglayer { namespace attribute {
	class ImpSdrFillAttribute;
	class FillGradientAttribute;
	class FillHatchAttribute;
	class SdrFillGraphicAttribute;
}}

//////////////////////////////////////////////////////////////////////////////

namespace drawinglayer
{
	namespace attribute
	{
		class DRAWINGLAYER_DLLPUBLIC SdrFillAttribute
		{
        private:
            ImpSdrFillAttribute*            mpSdrFillAttribute;

		public:
            /// constructors/assignmentoperator/destructor
			SdrFillAttribute(
				double fTransparence, 
                const basegfx::BColor& rColor, 
                const FillGradientAttribute& rGradient, 
				const FillHatchAttribute& rHatch, 
                const SdrFillGraphicAttribute& rFillGraphic);
			SdrFillAttribute();
			SdrFillAttribute(const SdrFillAttribute& rCandidate);
			SdrFillAttribute& operator=(const SdrFillAttribute& rCandidate);
			~SdrFillAttribute();

            // checks if the incarnation is default constructed
            bool isDefault() const;

            // compare operator
			bool operator==(const SdrFillAttribute& rCandidate) const;

			// data read access
			double getTransparence() const;
			const basegfx::BColor& getColor() const;
			const FillGradientAttribute& getGradient() const;
			const FillHatchAttribute& getHatch() const;
			const SdrFillGraphicAttribute& getFillGraphic() const;
		};
	} // end of namespace attribute
} // end of namespace drawinglayer

//////////////////////////////////////////////////////////////////////////////

#endif //INCLUDED_DRAWINGLAYER_ATTRIBUTE_SDRFILLATTRIBUTE_HXX

// eof
