/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/


#ifndef DBAUI_TABLEFIELDDESCRIPTION_HXX
#define DBAUI_TABLEFIELDDESCRIPTION_HXX

#ifndef _SV_TABPAGE_HXX 
#include <vcl/tabpage.hxx>
#endif
#ifndef DBAUI_TABLEFIELDDESCGENPAGE_HXX
#include "FieldDescGenWin.hxx"
#endif
#ifndef DBACCESS_TABLEDESIGN_ICLIPBOARDTEST_HXX
#include "IClipBoardTest.hxx"
#endif

class FixedText;
namespace dbaui
{
	class OFieldDescGenWin;
	class OTableDesignHelpBar;
	class OFieldDescription;
	//==================================================================
	// Ableitung von TabPage ist ein Trick von TH,
	// um Aenderungen der Systemfarben zu bemerken (Bug #53905)
	class OTableFieldDescWin : public TabPage
								,public IClipboardTest
	{
		enum ChildFocusState
		{
			DESCRIPTION,
			HELP,
			NONE
		};
	private:
		OTableDesignHelpBar*	m_pHelpBar;
		OFieldDescGenWin*		m_pGenPage;
		FixedText*				m_pHeader;
		ChildFocusState			m_eChildFocus;

		IClipboardTest* getActiveChild() const;

	protected:
		virtual void Resize();
		virtual void Paint( const Rectangle& rRect );

	public:
		OTableFieldDescWin( Window* pParent);
		virtual ~OTableFieldDescWin();

		virtual void Init();

		void DisplayData( OFieldDescription* pFieldDescr );
		void SaveData( OFieldDescription* pFieldDescr );
		void SetReadOnly( sal_Bool bReadOnly );

		// window overloads
		virtual long PreNotify( NotifyEvent& rNEvt );
		virtual void GetFocus();
		virtual void LoseFocus();

		void SetControlText( sal_uInt16 nControlId, const String& rText )
				{ m_pGenPage->SetControlText(nControlId,rText); }
		String GetControlText( sal_uInt16 nControlId )
				{ return m_pGenPage->GetControlText(nControlId); }

		//	short GetFormatCategory(OFieldDescription* pFieldDescr) { return m_pGenPage ? m_pGenPage->GetFormatCategory(pFieldDescr) : -1; }
			// liefert zum am Feld eingestellten Format einen der CAT_xxx-Werte (CAT_NUMBER, CAT_DATE ...)

		String	BoolStringPersistent(const String& rUIString) const { return m_pGenPage->BoolStringPersistent(rUIString); }
		String	BoolStringUI(const String& rPersistentString) const { return m_pGenPage->BoolStringUI(rPersistentString); }

		// IClipboardTest
		virtual sal_Bool isCutAllowed();
		virtual sal_Bool isCopyAllowed();
		virtual sal_Bool isPasteAllowed();
		virtual sal_Bool hasChildPathFocus() { return HasChildPathFocus(); }

		virtual void copy();
		virtual void cut();
		virtual void paste();

		inline OFieldDescGenWin* getGenPage() const { return m_pGenPage; }
		inline OTableDesignHelpBar*	getHelpBar() const { return m_pHelpBar; }

	};
}
#endif // DBAUI_TABLEFIELDDESCRIPTION_HXX




