/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/


#ifndef DBAUI_RELCONTROLIFACE_HXX
#define DBAUI_RELCONTROLIFACE_HXX

#ifndef _COM_SUN_STAR_SDBC_XCONNECTION_HPP_
#include <com/sun/star/sdbc/XConnection.hpp>
#endif
#include "TableConnectionData.hxx"

namespace dbaui
{
	class IRelationControlInterface
	{
	public:
		virtual ~IRelationControlInterface(){}

		/** getConnectionData returns the current connection data
			@return the current connectiondata
		*/
		virtual TTableConnectionData::value_type getConnectionData() const = 0;

		/** setValid set the valid inside, can be used for OK buttons
			@param	_bValid	true when the using control allows an update
		*/
		virtual void setValid(sal_Bool _bValid) = 0;

		virtual ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection > getConnection() = 0;

		/** notifyConnectionChange is callback which is called when the table selection has changed and a new connection exists
			@param	_pConnectionData	the connection which exists between the new tables
		*/
		virtual void notifyConnectionChange() = 0;
	};
}
#endif // DBAUI_RELCONTROLIFACE_HXX
