/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_dbaccess.hxx"

#ifndef DBAUI_FILEPICKER_INTERACTION_HXX
#include "finteraction.hxx"
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _COM_SUN_STAR_UCB_INTERACTIVEIOEXCEPTION_HPP_
#include <com/sun/star/ucb/InteractiveIOException.hpp>
#endif

//........................................................................
namespace dbaui
{
//........................................................................
	using namespace ::com::sun::star::uno;
	using namespace ::com::sun::star::task;
	using namespace ::com::sun::star::ucb;

	//====================================================================
	//= OFilePickerInteractionHandler
	//====================================================================
	DBG_NAME( OFilePickerInteractionHandler )
	//--------------------------------------------------------------------
	OFilePickerInteractionHandler::OFilePickerInteractionHandler( const Reference< XInteractionHandler >& _rxMaster )
		:m_xMaster( _rxMaster )
		,m_bDoesNotExist(sal_False)
	{
		DBG_CTOR( OFilePickerInteractionHandler, NULL );
		DBG_ASSERT( m_xMaster.is(), "OFilePickerInteractionHandler::OFilePickerInteractionHandler: invalid master handler!" );
	}

	//--------------------------------------------------------------------
	OFilePickerInteractionHandler::~OFilePickerInteractionHandler( )
	{
		DBG_DTOR( OFilePickerInteractionHandler, NULL );
	}

	//--------------------------------------------------------------------
	void SAL_CALL OFilePickerInteractionHandler::handle( const Reference< XInteractionRequest >& _rxRequest ) throw (RuntimeException)
	{
        InteractiveIOException aIoException;
		if ( _rxRequest->getRequest() >>= aIoException )
		{
			if ( IOErrorCode_NOT_EXISTING == aIoException.Code )
			{
				m_bDoesNotExist = sal_True;
				return;
			}
		}

		if ( m_xMaster.is() )
			m_xMaster->handle( _rxRequest );
	}

//........................................................................
}	// namespace svt
//........................................................................

