/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



#ifndef DBAUI_CONNECTIONPAGE_HXX
#define DBAUI_CONNECTIONPAGE_HXX

#ifndef DBAUI_CONNECTIONHELPER_HXX
#include "ConnectionHelper.hxx"
#endif
#ifndef _DBAUI_ADMINPAGES_HXX_
#include "adminpages.hxx"
#endif
#ifndef _UCBHELPER_CONTENT_HXX
#include <ucbhelper/content.hxx>
#endif
#ifndef _DBAUI_CURLEDIT_HXX_
#include "curledit.hxx"
#endif

//.........................................................................
namespace dbaui
{
//.........................................................................

	class IDatabaseSettingsDialog;
	//=========================================================================
	//= OConnectionTabPage
	//=========================================================================

	/** implements the connection page of teh data source properties dialog.
	*/
	class OConnectionTabPage : public OConnectionHelper
	{
		sal_Bool			m_bUserGrabFocus : 1;
	protected:
		// connection 
		FixedLine			m_aFL1;
		// user authentification
		FixedLine			m_aFL2;
		FixedText			m_aUserNameLabel;
		Edit				m_aUserName;
		CheckBox			m_aPasswordRequired;

		// jdbc driver
		FixedLine			m_aFL3;
		FixedText			m_aJavaDriverLabel;
		Edit				m_aJavaDriver;
		PushButton			m_aTestJavaDriver;

		// connection test
		PushButton			m_aTestConnection;


		// called when the test connection button was clicked
		DECL_LINK(OnTestJavaClickHdl,PushButton*);
		DECL_LINK(OnEditModified,Edit*);

	public:
		static	SfxTabPage*	Create( Window* pParent, const SfxItemSet& _rAttrSet );
		virtual	sal_Bool		FillItemSet	(SfxItemSet& _rCoreAttrs);

		virtual void		implInitControls(const SfxItemSet& _rSet, sal_Bool _bSaveValue);

		inline void enableConnectionURL() { m_aConnectionURL.SetReadOnly(sal_False); }
		inline void disableConnectionURL() { m_aConnectionURL.SetReadOnly(); }

		/** changes the connection URL.
			<p>The new URL must be of the type which is currently selected, only the parts which do not
			affect the type may be changed (compared to the previous URL).</p>
		*/
	private:
		OConnectionTabPage(Window* pParent, const SfxItemSet& _rCoreAttrs);
			// nControlFlags ist eine Kombination der CBTP_xxx-Konstanten
		virtual ~OConnectionTabPage();

		// <method>OGenericAdministrationPage::fillControls</method>
		virtual void fillControls(::std::vector< ISaveValueWrapper* >& _rControlList);
		// <method>OGenericAdministrationPage::fillWindows</method>
		virtual void fillWindows(::std::vector< ISaveValueWrapper* >& _rControlList);

	private:
		/** enables the test connection button, if allowed
		*/
		virtual bool checkTestConnection();
	};
//.........................................................................
}	// namespace dbaui
//.........................................................................

#endif // _DBAUI_DETAILPAGES_HXX_
