/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_cui.hxx"

#include <tools/shl.hxx>
#include <unotools/searchopt.hxx>
#include <com/sun/star/i18n/TransliterationModules.hpp>
#include <cuires.hrc>
#include <dialmgr.hxx>
#include <optjsearch.hxx>
#include "optjsearch.hrc"

using namespace com::sun::star::i18n;

//////////////////////////////////////////////////////////////////////

SvxJSearchOptionsPage::SvxJSearchOptionsPage( Window* pParent, const SfxItemSet& rSet ) :
	SfxTabPage( pParent, CUI_RES( RID_SVXPAGE_JSEARCH_OPTIONS ), rSet ),

	aTreatAsEqual				( this, CUI_RES( FL_TREAT_AS_EQUAL ) ),
	aMatchCase					( this, CUI_RES( CB_MATCH_CASE ) ),
	aMatchFullHalfWidth			( this, CUI_RES( CB_MATCH_FULL_HALF_WIDTH ) ),
	aMatchHiraganaKatakana		( this, CUI_RES( CB_MATCH_HIRAGANA_KATAKANA ) ),
	aMatchContractions			( this, CUI_RES( CB_MATCH_CONTRACTIONS ) ),
	aMatchMinusDashChoon		( this, CUI_RES( CB_MATCH_MINUS_DASH_CHOON ) ),
	aMatchRepeatCharMarks		( this, CUI_RES( CB_MATCH_REPEAT_CHAR_MARKS ) ),
	aMatchVariantFormKanji		( this, CUI_RES( CB_MATCH_VARIANT_FORM_KANJI ) ),
	aMatchOldKanaForms			( this, CUI_RES( CB_MATCH_OLD_KANA_FORMS ) ),
	aMatchDiziDuzu				( this, CUI_RES( CB_MATCH_DIZI_DUZU ) ),
	aMatchBavaHafa				( this, CUI_RES( CB_MATCH_BAVA_HAFA ) ),
	aMatchTsithichiDhizi		( this, CUI_RES( CB_MATCH_TSITHICHI_DHIZI ) ),
	aMatchHyuiyuByuvyu			( this, CUI_RES( CB_MATCH_HYUFYU_BYUVYU ) ),
	aMatchSesheZeje				( this, CUI_RES( CB_MATCH_SESHE_ZEJE ) ),
	aMatchIaiya					( this, CUI_RES( CB_MATCH_IAIYA ) ),
	aMatchKiku					( this, CUI_RES( CB_MATCH_KIKU ) ),
    aMatchProlongedSoundMark    ( this, CUI_RES( CB_MATCH_PROLONGED_SOUNDMARK ) ),
    aIgnore                     ( this, CUI_RES( FL_IGNORE ) ),
	aIgnorePunctuation			( this, CUI_RES( CB_IGNORE_PUNCTUATION ) ),
	aIgnoreWhitespace			( this, CUI_RES( CB_IGNORE_WHITESPACES ) ),
    aIgnoreMiddleDot            ( this, CUI_RES( CB_IGNORE_MIDDLE_DOT ) )
{
	FreeResource();
	bSaveOptions = sal_True;
	nTransliterationFlags = 0x00000000;
}


SvxJSearchOptionsPage::~SvxJSearchOptionsPage()
{
}


SfxTabPage*  SvxJSearchOptionsPage::Create( Window* pParent, const SfxItemSet& rSet )
{
	return new SvxJSearchOptionsPage( pParent, rSet );
}


void SvxJSearchOptionsPage::SetTransliterationFlags( sal_Int32 nSettings )
{
	sal_Bool  bVal = 0 != (nSettings & TransliterationModules_IGNORE_CASE);
    aMatchCase               .Check( bVal );    //! treat as equal uppercase/lowercase
	bVal = 0 != (nSettings & TransliterationModules_IGNORE_WIDTH);
    aMatchFullHalfWidth      .Check( bVal );
	bVal = 0 != (nSettings & TransliterationModules_IGNORE_KANA);
    aMatchHiraganaKatakana   .Check( bVal );
	bVal = 0 != (nSettings & TransliterationModules_ignoreSize_ja_JP);
    aMatchContractions       .Check( bVal );
	bVal = 0 != (nSettings & TransliterationModules_ignoreMinusSign_ja_JP);
    aMatchMinusDashChoon     .Check( bVal );
	bVal = 0 != (nSettings & TransliterationModules_ignoreIterationMark_ja_JP);
    aMatchRepeatCharMarks    .Check( bVal );
	bVal = 0 != (nSettings & TransliterationModules_ignoreTraditionalKanji_ja_JP);
    aMatchVariantFormKanji   .Check( bVal );
	bVal = 0 != (nSettings & TransliterationModules_ignoreTraditionalKana_ja_JP);
    aMatchOldKanaForms       .Check( bVal );
	bVal = 0 != (nSettings & TransliterationModules_ignoreZiZu_ja_JP);
    aMatchDiziDuzu           .Check( bVal );
	bVal = 0 != (nSettings & TransliterationModules_ignoreBaFa_ja_JP);
    aMatchBavaHafa           .Check( bVal );
	bVal = 0 != (nSettings & TransliterationModules_ignoreTiJi_ja_JP);
    aMatchTsithichiDhizi     .Check( bVal );
	bVal = 0 != (nSettings & TransliterationModules_ignoreHyuByu_ja_JP);
    aMatchHyuiyuByuvyu       .Check( bVal );
	bVal = 0 != (nSettings & TransliterationModules_ignoreSeZe_ja_JP);
    aMatchSesheZeje          .Check( bVal );
	bVal = 0 != (nSettings & TransliterationModules_ignoreIandEfollowedByYa_ja_JP);
    aMatchIaiya              .Check( bVal );
	bVal = 0 != (nSettings & TransliterationModules_ignoreKiKuFollowedBySa_ja_JP);
    aMatchKiku               .Check( bVal );
	bVal = 0 != (nSettings & TransliterationModules_ignoreSeparator_ja_JP);
	aIgnorePunctuation		 .Check( bVal );
	bVal = 0 != (nSettings & TransliterationModules_ignoreSpace_ja_JP);
	aIgnoreWhitespace		 .Check( bVal );
	bVal = 0 != (nSettings & TransliterationModules_ignoreProlongedSoundMark_ja_JP);
    aMatchProlongedSoundMark.Check( bVal );
	bVal = 0 != (nSettings & TransliterationModules_ignoreMiddleDot_ja_JP);
	aIgnoreMiddleDot		 .Check( bVal );

	nTransliterationFlags = nSettings;
}


sal_Int32 SvxJSearchOptionsPage::GetTransliterationFlags_Impl()
{
	sal_Int32 nTmp = 0;
    if (aMatchCase.IsChecked()) //! treat as equal uppercase/lowercase
		nTmp |= TransliterationModules_IGNORE_CASE;
    if (aMatchFullHalfWidth.IsChecked())
		nTmp |= TransliterationModules_IGNORE_WIDTH;
    if (aMatchHiraganaKatakana.IsChecked())
		nTmp |= TransliterationModules_IGNORE_KANA;
    if (aMatchContractions.IsChecked())
		nTmp |= TransliterationModules_ignoreSize_ja_JP;
    if (aMatchMinusDashChoon.IsChecked())
		nTmp |= TransliterationModules_ignoreMinusSign_ja_JP;
    if (aMatchRepeatCharMarks.IsChecked())
		nTmp |= TransliterationModules_ignoreIterationMark_ja_JP;
    if (aMatchVariantFormKanji.IsChecked())
		nTmp |= TransliterationModules_ignoreTraditionalKanji_ja_JP;
    if (aMatchOldKanaForms.IsChecked())
		nTmp |= TransliterationModules_ignoreTraditionalKana_ja_JP;
    if (aMatchDiziDuzu.IsChecked())
		nTmp |= TransliterationModules_ignoreZiZu_ja_JP;
    if (aMatchBavaHafa.IsChecked())
		nTmp |= TransliterationModules_ignoreBaFa_ja_JP;
    if (aMatchTsithichiDhizi.IsChecked())
		nTmp |= TransliterationModules_ignoreTiJi_ja_JP;
    if (aMatchHyuiyuByuvyu.IsChecked())
		nTmp |= TransliterationModules_ignoreHyuByu_ja_JP;
    if (aMatchSesheZeje.IsChecked())
		nTmp |= TransliterationModules_ignoreSeZe_ja_JP;
    if (aMatchIaiya.IsChecked())
		nTmp |= TransliterationModules_ignoreIandEfollowedByYa_ja_JP;
    if (aMatchKiku.IsChecked())
		nTmp |= TransliterationModules_ignoreKiKuFollowedBySa_ja_JP;
    if (aIgnorePunctuation.IsChecked())
		nTmp |= TransliterationModules_ignoreSeparator_ja_JP;
    if (aIgnoreWhitespace.IsChecked())
		nTmp |= TransliterationModules_ignoreSpace_ja_JP;
    if (aMatchProlongedSoundMark.IsChecked())
		nTmp |= TransliterationModules_ignoreProlongedSoundMark_ja_JP;
    if (aIgnoreMiddleDot.IsChecked())
		nTmp |= TransliterationModules_ignoreMiddleDot_ja_JP;

	nTransliterationFlags = nTmp;
	return nTransliterationFlags;
}


void SvxJSearchOptionsPage::Reset( const SfxItemSet& )
{
	SvtSearchOptions aOpt;

	// read settings from configuration
    aMatchCase               .Check(!aOpt.IsMatchCase() );  //! treat as equal uppercase/lowercase
	aMatchFullHalfWidth		 .Check( aOpt.IsMatchFullHalfWidthForms() );
	aMatchHiraganaKatakana	 .Check( aOpt.IsMatchHiraganaKatakana() );
	aMatchContractions		 .Check( aOpt.IsMatchContractions() );
	aMatchMinusDashChoon	 .Check( aOpt.IsMatchMinusDashChoon() );
	aMatchRepeatCharMarks	 .Check( aOpt.IsMatchRepeatCharMarks() );
	aMatchVariantFormKanji	 .Check( aOpt.IsMatchVariantFormKanji() );
	aMatchOldKanaForms		 .Check( aOpt.IsMatchOldKanaForms() );
	aMatchDiziDuzu			 .Check( aOpt.IsMatchDiziDuzu() );
	aMatchBavaHafa			 .Check( aOpt.IsMatchBavaHafa() );
	aMatchTsithichiDhizi	 .Check( aOpt.IsMatchTsithichiDhizi() );
	aMatchHyuiyuByuvyu		 .Check( aOpt.IsMatchHyuiyuByuvyu() );
	aMatchSesheZeje			 .Check( aOpt.IsMatchSesheZeje() );
	aMatchIaiya				 .Check( aOpt.IsMatchIaiya() );
	aMatchKiku				 .Check( aOpt.IsMatchKiku() );
	aIgnorePunctuation		 .Check( aOpt.IsIgnorePunctuation() );
	aIgnoreWhitespace		 .Check( aOpt.IsIgnoreWhitespace() );
    aMatchProlongedSoundMark .Check( aOpt.IsIgnoreProlongedSoundMark() );
	aIgnoreMiddleDot		 .Check( aOpt.IsIgnoreMiddleDot() );

	nTransliterationFlags = GetTransliterationFlags_Impl();
	DBG_ASSERT( nTransliterationFlags == aOpt.GetTransliterationFlags(),
			"Transliteration settings different" );

	aMatchCase				 .SaveValue();
	aMatchFullHalfWidth		 .SaveValue();
	aMatchHiraganaKatakana	 .SaveValue();
	aMatchContractions		 .SaveValue();
	aMatchMinusDashChoon	 .SaveValue();
	aMatchRepeatCharMarks	 .SaveValue();
	aMatchVariantFormKanji	 .SaveValue();
	aMatchOldKanaForms		 .SaveValue();
	aMatchDiziDuzu			 .SaveValue();
	aMatchBavaHafa			 .SaveValue();
	aMatchTsithichiDhizi	 .SaveValue();
	aMatchHyuiyuByuvyu		 .SaveValue();
	aMatchSesheZeje			 .SaveValue();
	aMatchIaiya				 .SaveValue();
	aMatchKiku				 .SaveValue();
	aIgnorePunctuation		 .SaveValue();
	aIgnoreWhitespace		 .SaveValue();
    aMatchProlongedSoundMark .SaveValue();
	aIgnoreMiddleDot		 .SaveValue();
}


sal_Bool SvxJSearchOptionsPage::FillItemSet( SfxItemSet& )
{
	sal_Bool bModified = sal_False;

    sal_Int32 nOldVal = nTransliterationFlags;
	nTransliterationFlags = GetTransliterationFlags_Impl();
    bModified = nOldVal != nTransliterationFlags;

	if (!IsSaveOptions())
		return bModified;

    bModified = sal_False;
	SvtSearchOptions aOpt;
	sal_Bool bNewVal, bChanged;

    bNewVal  = aMatchCase.IsChecked();  //! treat as equal uppercase/lowercase
	bChanged = bNewVal != aMatchCase.GetSavedValue();
	if (bChanged)
	{
        aOpt.SetMatchCase(!bNewVal );
		bModified = sal_True;
	}
	bNewVal  = aMatchFullHalfWidth.IsChecked();
	bChanged = bNewVal != aMatchFullHalfWidth.GetSavedValue();
	if (bChanged)
	{
		aOpt.SetMatchFullHalfWidthForms( bNewVal );
		bModified = sal_True;
	}
	bNewVal  = aMatchHiraganaKatakana.IsChecked();
	bChanged = bNewVal != aMatchHiraganaKatakana.GetSavedValue();
	if (bChanged)
	{
		aOpt.SetMatchHiraganaKatakana( bNewVal );
		bModified = sal_True;
	}
	bNewVal  = aMatchContractions.IsChecked();
	bChanged = bNewVal != aMatchContractions.GetSavedValue();
	if (bChanged)
	{
		aOpt.SetMatchContractions( bNewVal );
		bModified = sal_True;
	}
	bNewVal  = aMatchMinusDashChoon.IsChecked();
	bChanged = bNewVal != aMatchMinusDashChoon.GetSavedValue();
	if (bChanged)
	{
		aOpt.SetMatchMinusDashChoon( bNewVal );
		bModified = sal_True;
	}
	bNewVal  = aMatchRepeatCharMarks.IsChecked();
	bChanged = bNewVal != aMatchRepeatCharMarks.GetSavedValue();
	if (bChanged)
	{
		aOpt.SetMatchRepeatCharMarks( bNewVal );
		bModified = sal_True;
	}
	bNewVal  = aMatchVariantFormKanji.IsChecked();
	bChanged = bNewVal != aMatchVariantFormKanji.GetSavedValue();
	if (bChanged)
	{
		aOpt.SetMatchVariantFormKanji( bNewVal );
		bModified = sal_True;
	}
	bNewVal  = aMatchOldKanaForms.IsChecked();
	bChanged = bNewVal != aMatchOldKanaForms.GetSavedValue();
	if (bChanged)
	{
		aOpt.SetMatchOldKanaForms( bNewVal );
		bModified = sal_True;
	}
	bNewVal  = aMatchDiziDuzu.IsChecked();
	bChanged = bNewVal != aMatchDiziDuzu.GetSavedValue();
	if (bChanged)
	{
		aOpt.SetMatchDiziDuzu( bNewVal );
		bModified = sal_True;
	}
	bNewVal  = aMatchBavaHafa.IsChecked();
	bChanged = bNewVal != aMatchBavaHafa.GetSavedValue();
	if (bChanged)
	{
		aOpt.SetMatchBavaHafa( bNewVal );
		bModified = sal_True;
	}
	bNewVal  = aMatchTsithichiDhizi.IsChecked();
	bChanged = bNewVal != aMatchTsithichiDhizi.GetSavedValue();
	if (bChanged)
	{
		aOpt.SetMatchTsithichiDhizi( bNewVal );
		bModified = sal_True;
	}
	bNewVal  = aMatchHyuiyuByuvyu.IsChecked();
	bChanged = bNewVal != aMatchHyuiyuByuvyu.GetSavedValue();
	if (bChanged)
	{
		aOpt.SetMatchHyuiyuByuvyu( bNewVal );
		bModified = sal_True;
	}
	bNewVal  = aMatchSesheZeje.IsChecked();
	bChanged = bNewVal != aMatchSesheZeje.GetSavedValue();
	if (bChanged)
	{
		aOpt.SetMatchSesheZeje( bNewVal );
		bModified = sal_True;
	}
	bNewVal  = aMatchIaiya.IsChecked();
	bChanged = bNewVal != aMatchIaiya.GetSavedValue();
	if (bChanged)
	{
		aOpt.SetMatchIaiya( bNewVal );
		bModified = sal_True;
	}
	bNewVal  = aMatchKiku.IsChecked();
	bChanged = bNewVal != aMatchKiku.GetSavedValue();
	if (bChanged)
	{
		aOpt.SetMatchKiku( bNewVal );
		bModified = sal_True;
	}
	bNewVal  = aIgnorePunctuation.IsChecked();
	bChanged = bNewVal != aIgnorePunctuation.GetSavedValue();
	if (bChanged)
	{
		aOpt.SetIgnorePunctuation( bNewVal );
		bModified = sal_True;
	}
	bNewVal  = aIgnoreWhitespace.IsChecked();
	bChanged = bNewVal != aIgnoreWhitespace.GetSavedValue();
	if (bChanged)
	{
		aOpt.SetIgnoreWhitespace( bNewVal );
		bModified = sal_True;
	}
    bNewVal  = aMatchProlongedSoundMark.IsChecked();
    bChanged = bNewVal != aMatchProlongedSoundMark.GetSavedValue();
	if (bChanged)
	{
        aOpt.SetIgnoreProlongedSoundMark( bNewVal );
		bModified = sal_True;
	}
	bNewVal  = aIgnoreMiddleDot.IsChecked();
	bChanged = bNewVal != aIgnoreMiddleDot.GetSavedValue();
	if (bChanged)
	{
		aOpt.SetIgnoreMiddleDot( bNewVal );
		bModified = sal_True;
	}

	return bModified;
}


//////////////////////////////////////////////////////////////////////

