/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/


#ifndef _CPPU_MACROS_HXX_
#define _CPPU_MACROS_HXX_

#include <sal/types.h>
#include <uno/lbnames.h>

/** Namespace name for compiler/ platform, e.g. gcc3, msci */
#define	CPPU_CURRENT_NAMESPACE CPPU_ENV

/** Patching the GCC 3 incomatible alignment change for Linux.

    This macro is appended by cppumaker to every first member of a struct, if
    the struct inherits from a base struct and the first member is neither
    double nor sal_[u]Int64.  (The double/sal_[u]Int64 restriction is due to a
    bug in GCC prior to version 3.3, which would cause __alignof__ of such a
    struct to become 8 instead of 4 if CPPU_GCC3_ALIGN were added to its first
    member.)

    @internal
*/
#if defined(__GNUC__) && (__GNUC__ >= 3)
#define CPPU_GCC3_ALIGN( base_struct ) __attribute__ ((aligned (__alignof__ (base_struct))))
#else
#define CPPU_GCC3_ALIGN( base_struct )
#endif

/**
   Exporting the symbols necessary for exception handling on GCC.

   These macros are used in the headers generated by cppumaker for UNO exception
   types, to ensure that exception handling does not fail on GCC.

   @internal
*/
#define CPPU_GCC_DLLPUBLIC_EXPORT SAL_EXCEPTION_DLLPUBLIC_EXPORT
#define CPPU_GCC_DLLPRIVATE SAL_EXCEPTION_DLLPRIVATE

#endif	// _CPPU_MACROS_HXX_

