/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/


#ifndef CONNECTIVITY_HSQLDB_COLUMN_HXX
#define CONNECTIVITY_HSQLDB_COLUMN_HXX
#include "connectivity/TColumnsHelper.hxx"
#include "connectivity/sdbcx/VColumn.hxx"

namespace connectivity
{
	namespace hsqldb
	{
		class OHSQLColumns : public OColumnsHelper
		{
		protected:
			virtual ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet > createDescriptor();
		public:
			OHSQLColumns(	::cppu::OWeakObject& _rParent
							,sal_Bool _bCase
							,::osl::Mutex& _rMutex
							,const TStringVector &_rVector
							,sal_Bool _bUseHardRef = sal_True
						);
		};

		class OHSQLColumn;
		typedef sdbcx::OColumn OHSQLColumn_BASE;
		typedef ::comphelper::OIdPropertyArrayUsageHelper<OHSQLColumn> OHSQLColumn_PROP;

		class OHSQLColumn :	public OHSQLColumn_BASE,
								public OHSQLColumn_PROP
		{
			::rtl::OUString m_sAutoIncrement;
		protected:
			virtual ::cppu::IPropertyArrayHelper* createArrayHelper( sal_Int32 _nId) const;
			virtual ::cppu::IPropertyArrayHelper & SAL_CALL getInfoHelper();

		public:
            OHSQLColumn(sal_Bool _bCase);
			virtual void construct();

			virtual ::com::sun::star::uno::Sequence< ::rtl::OUString > SAL_CALL getSupportedServiceNames(  ) throw(::com::sun::star::uno::RuntimeException);
		};
	}
}
#endif // CONNECTIVITY_HSQLDB_COLUMN_HXX

