/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/


#ifndef _CONNECTIVITY_FILE_OCONNECTION_HXX_
#define _CONNECTIVITY_FILE_OCONNECTION_HXX_

#include <com/sun/star/ucb/XContent.hpp>
#include <com/sun/star/sdbc/SQLWarning.hpp>
#include <com/sun/star/beans/PropertyValue.hpp>
#include "OSubComponent.hxx"
#ifndef _MAP_
#include <map>
#endif
#include "connectivity/CommonTools.hxx"
#include "OTypeInfo.hxx"
#include <tools/string.hxx>
#include <com/sun/star/sdbcx/XTablesSupplier.hpp>
#include <com/sun/star/ucb/XDynamicResultSet.hpp>
#include "connectivity/sqlparse.hxx"
#include "connectivity/sqliterator.hxx"
#include "TConnection.hxx"
#include "file/filedllapi.hxx"

namespace connectivity
{
	namespace file
	{

		class OStatement_Base;
		class ODatabaseMetaData;
		class OFileDriver;

		class OOO_DLLPUBLIC_FILE OConnection :
                            public connectivity::OMetaConnection,
							public connectivity::OSubComponent<OConnection, connectivity::OMetaConnection>
		{
			friend class connectivity::OSubComponent<OConnection, connectivity::OMetaConnection>;

		protected:
			//====================================================================
			// Data attributes
			//====================================================================
            ::com::sun::star::uno::WeakReference< ::com::sun::star::sdbcx::XTablesSupplier>			m_xCatalog;

			::com::sun::star::sdbc::SQLWarning            m_aLastWarning; //      Last SQLWarning generated by

			String						m_aFilenameExtension;
			OFileDriver*				m_pDriver;		//	Pointer to the owning
														//  driver object
			::com::sun::star::uno::Reference< ::com::sun::star::ucb::XDynamicResultSet >	m_xDir; // directory
			::com::sun::star::uno::Reference< ::com::sun::star::ucb::XContent>				m_xContent;

			sal_Bool					m_bClosed;
			sal_Bool					m_bAutoCommit;
			sal_Bool					m_bReadOnly;
			sal_Bool					m_bShowDeleted;
			sal_Bool					m_bCaseSensitiveExtension;
			sal_Bool					m_bCheckSQL92;
            bool                        m_bDefaultTextEncoding;


			void throwUrlNotValid(const ::rtl::OUString & _rsUrl,const ::rtl::OUString & _rsMessage);

			virtual ~OConnection();
		public:

			OConnection(OFileDriver*	_pDriver);
			
            virtual void construct(const ::rtl::OUString& _rUrl,const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& _rInfo ) throw( ::com::sun::star::sdbc::SQLException);

            void closeAllStatements () throw( ::com::sun::star::sdbc::SQLException);

			// OComponentHelper
			virtual void SAL_CALL disposing(void);
			// XInterface
			virtual void SAL_CALL release() throw();

			// XServiceInfo
			DECLARE_SERVICE_INFO();

			// XConnection
            virtual ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XStatement > SAL_CALL createStatement(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XPreparedStatement > SAL_CALL prepareStatement( const ::rtl::OUString& sql ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XPreparedStatement > SAL_CALL prepareCall( const ::rtl::OUString& sql ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual ::rtl::OUString SAL_CALL nativeSQL( const ::rtl::OUString& sql ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual void SAL_CALL setAutoCommit( sal_Bool autoCommit ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual sal_Bool SAL_CALL getAutoCommit(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual void SAL_CALL commit(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual void SAL_CALL rollback(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual sal_Bool SAL_CALL isClosed(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XDatabaseMetaData > SAL_CALL getMetaData(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual void SAL_CALL setReadOnly( sal_Bool readOnly ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual sal_Bool SAL_CALL isReadOnly(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual void SAL_CALL setCatalog( const ::rtl::OUString& catalog ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual ::rtl::OUString SAL_CALL getCatalog(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual void SAL_CALL setTransactionIsolation( sal_Int32 level ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual sal_Int32 SAL_CALL getTransactionIsolation(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual ::com::sun::star::uno::Reference< ::com::sun::star::container::XNameAccess > SAL_CALL getTypeMap(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
            virtual void SAL_CALL setTypeMap( const ::com::sun::star::uno::Reference< ::com::sun::star::container::XNameAccess >& typeMap ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
			// XCloseable
			virtual void SAL_CALL close(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
			// XWarningsSupplier
			virtual ::com::sun::star::uno::Any SAL_CALL getWarnings(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
			virtual void SAL_CALL clearWarnings(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException);
			//XUnoTunnel 
			virtual sal_Int64 SAL_CALL getSomething( const ::com::sun::star::uno::Sequence< sal_Int8 >& aIdentifier ) throw (::com::sun::star::uno::RuntimeException);
			static ::com::sun::star::uno::Sequence< sal_Int8 > getUnoTunnelImplementationId();

			// no interface methods
			::com::sun::star::uno::Reference< ::com::sun::star::ucb::XDynamicResultSet > getDir() const;
			::com::sun::star::uno::Reference< ::com::sun::star::ucb::XContent>	getContent() const { return m_xContent; }
			// create a catalog or return the catalog already created
            virtual ::com::sun::star::uno::Reference< ::com::sun::star::sdbcx::XTablesSupplier > createCatalog();

			sal_Bool				matchesExtension( const String& _rExt ) const;

			inline const String&	getExtension()				const { return m_aFilenameExtension; }
			inline sal_Bool			isCaseSensitveExtension()	const { return m_bCaseSensitiveExtension; }
			inline OFileDriver*		getDriver()					const { return m_pDriver; }
			inline sal_Bool			showDeleted()				const { return m_bShowDeleted; }
			inline sal_Bool			isCheckEnabled()			const { return m_bCheckSQL92; }
            inline bool             isTextEncodingDefaulted()   const { return m_bDefaultTextEncoding; }

		public:
			struct GrantAccess
			{
				friend class ODatabaseMetaData;
			private:
				GrantAccess() { }
			};

			void	setCaseSensitiveExtension( sal_Bool _bIsCS, GrantAccess ) { m_bCaseSensitiveExtension = _bIsCS; }
		};
	}
}
#endif // _CONNECTIVITY_FILE_OCONNECTION_HXX_

