/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



#ifndef _CONNECTIVITY_OTYPEINFO_HXX_
#define _CONNECTIVITY_OTYPEINFO_HXX_

#include <com/sun/star/sdbc/ColumnSearch.hpp>
#include <com/sun/star/sdbc/DataType.hpp>
#include "connectivity/dbtoolsdllapi.hxx"

namespace connectivity
{
	struct OTypeInfo
	{
		::rtl::OUString	aTypeName;		// Name des Types in der Datenbank
		::rtl::OUString	aLiteralPrefix; // Prefix zum Quoten
		::rtl::OUString	aLiteralSuffix; // Suffix zum Quoten
		::rtl::OUString	aCreateParams;  // Parameter zum Erstellen
		::rtl::OUString	aLocalTypeName;

		sal_Int32		nPrecision;		// Laenge des Types

		sal_Int16		nMaximumScale;	// Nachkommastellen
		sal_Int16		nMinimumScale;  // Min Nachkommastellen

		sal_Int16		nType;			// Datenbanktyp
		sal_Int16		nSearchType;	// kann nach dem Typen gesucht werden
		sal_Int16		nNumPrecRadix;	// indicating the radix, which is usually 2 or 10

		sal_Bool		bCurrency		: 1,	// Waehrung
						bAutoIncrement	: 1,	// Ist es ein automatisch incrementierendes Feld
						bNullable		: 1,	// Kann das Feld NULL annehmen
						bCaseSensitive	: 1,	// Ist der Type Casesensitive
						bUnsigned		: 1,	// Ist der Type Unsigned
						bEmpty_1		: 1,	// for later use
						bEmpty_2		: 1;

		OTypeInfo()
                :nPrecision(0)
                ,nMaximumScale(0)
                ,nMinimumScale(0)
                ,nType( ::com::sun::star::sdbc::DataType::OTHER)
                ,nSearchType( ::com::sun::star::sdbc::ColumnSearch::FULL)
				,bCurrency(sal_False)
				,bAutoIncrement(sal_False)
				,bNullable(sal_True)
				,bCaseSensitive(sal_False)
				,bUnsigned(sal_False)
		{}

		inline static void * SAL_CALL operator new( size_t nSize ) SAL_THROW( () )
			{ return ::rtl_allocateMemory( nSize ); }
		inline static void * SAL_CALL operator new( size_t /*nSize*/,void* _pHint ) SAL_THROW( () )
			{ return _pHint; }
		inline static void SAL_CALL operator delete( void * pMem ) SAL_THROW( () )
			{ ::rtl_freeMemory( pMem ); }
		inline static void SAL_CALL operator delete( void * /*pMem*/,void* /*_pHint*/ ) SAL_THROW( () )
			{  }

		sal_Bool operator == (const OTypeInfo& lh) const { return lh.nType == nType; }
		sal_Bool operator != (const OTypeInfo& lh) const { return lh.nType != nType; }

		inline ::rtl::OUString getDBName() const { return aTypeName; }
	};
}
#endif // _CONNECTIVITY_OTYPEINFO_HXX_


