/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



#ifndef _CONNECTIVITY_KAB_TABLE_HXX_
#define _CONNECTIVITY_KAB_TABLE_HXX_

#include "KConnection.hxx"
#include "connectivity/sdbcx/VTable.hxx"

namespace connectivity
{
	namespace kab
	{
		typedef connectivity::sdbcx::OTable KabTable_TYPEDEF;

		::rtl::OUString getTypeString(const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet >& xColProp);

		class KabTable : public KabTable_TYPEDEF
		{
			::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XDatabaseMetaData > m_xMetaData;
			KabConnection* m_pConnection;

		public:
			KabTable(	sdbcx::OCollection* _pTables, KabConnection* _pConnection);
			KabTable(	sdbcx::OCollection* _pTables, 
					KabConnection* _pConnection,
					const ::rtl::OUString& _Name,
					const ::rtl::OUString& _Type,
					const ::rtl::OUString& _Description = ::rtl::OUString(),
					const ::rtl::OUString& _SchemaName = ::rtl::OUString(),
					const ::rtl::OUString& _CatalogName = ::rtl::OUString()
				);

			KabConnection* getConnection() { return m_pConnection;}

			virtual void refreshColumns();

			::rtl::OUString getTableName() const { return m_Name; }
			::rtl::OUString getSchema() const { return m_SchemaName; }
		};
	}
}

#endif // _CONNECTIVITY_KAB_TABLE_HXX_
