/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_connectivity.hxx"


#include "dbase/DCatalog.hxx"
#include "dbase/DConnection.hxx"
#include "dbase/DTables.hxx"
#include <com/sun/star/sdbc/XRow.hpp>
#include <com/sun/star/sdbc/XResultSet.hpp>

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::sdbcx;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::container;

// -------------------------------------------------------------------------
using namespace connectivity::dbase;
// -------------------------------------------------------------------------
ODbaseCatalog::ODbaseCatalog(ODbaseConnection* _pCon) : file::OFileCatalog(_pCon)
{
}
// -------------------------------------------------------------------------
void ODbaseCatalog::refreshTables()
{
	TStringVector aVector;
	Sequence< ::rtl::OUString > aTypes;
	Reference< XResultSet > xResult = m_xMetaData->getTables(Any(),
		::rtl::OUString::createFromAscii("%"),::rtl::OUString::createFromAscii("%"),aTypes);

	if(xResult.is())
	{
		Reference< XRow > xRow(xResult,UNO_QUERY);
		while(xResult->next())
			aVector.push_back(xRow->getString(3));
	}
	if(m_pTables)
		m_pTables->reFill(aVector);
	else
		m_pTables = new ODbaseTables(m_xMetaData,*this,m_aMutex,aVector);
}


