/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_connectivity.hxx"
#include "calc/CColumns.hxx"
#include "calc/CTable.hxx"
#include "connectivity/sdbcx/VColumn.hxx"

using namespace connectivity::calc;
using namespace connectivity;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::sdbcx;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::container;


sdbcx::ObjectType OCalcColumns::createObject(const ::rtl::OUString& _rName)
{
	OCalcTable* pTable = (OCalcTable*)m_pTable;
	::vos::ORef<OSQLColumns> aCols = pTable->getTableColumns();

	OSQLColumns::Vector::const_iterator aIter = find(aCols->get().begin(),aCols->get().end(),_rName,::comphelper::UStringMixEqual(isCaseSensitive()));
	sdbcx::ObjectType xRet;
	if(aIter != aCols->get().end())
		xRet = sdbcx::ObjectType(*aIter,UNO_QUERY);
	return xRet;
}
// -------------------------------------------------------------------------

