/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_connectivity.hxx"
#include "adabas/BDriver.hxx"
#include <cppuhelper/factory.hxx>

using namespace connectivity::adabas;
using ::rtl::OUString;
using ::com::sun::star::uno::Reference;
using ::com::sun::star::uno::Sequence;
using ::com::sun::star::lang::XSingleServiceFactory;
using ::com::sun::star::lang::XMultiServiceFactory;

typedef Reference< XSingleServiceFactory > (SAL_CALL *createFactoryFunc)
		(
			const Reference< XMultiServiceFactory > & rServiceManager,
			const OUString & rComponentName,
			::cppu::ComponentInstantiation pCreateFunction,
			const Sequence< OUString > & rServiceNames,
			rtl_ModuleCount* _pT
		);

//---------------------------------------------------------------------------------------
struct ProviderRequest
{
	Reference< XSingleServiceFactory > xRet;
	Reference< XMultiServiceFactory > const xServiceManager;
	OUString const sImplementationName;

	ProviderRequest(
		void* pServiceManager,
		sal_Char const* pImplementationName
	)
	: xServiceManager(reinterpret_cast<XMultiServiceFactory*>(pServiceManager))
	, sImplementationName(OUString::createFromAscii(pImplementationName))
	{
	}

	inline
	sal_Bool CREATE_PROVIDER(
				const OUString& Implname,
				const Sequence< OUString > & Services,
				::cppu::ComponentInstantiation Factory,
				createFactoryFunc creator
			)
	{
		if (!xRet.is() && (Implname == sImplementationName))
		try
		{
			xRet = creator( xServiceManager, sImplementationName,Factory, Services,0);
		}
		catch(...)
		{
		}
		return xRet.is();
	}

	void* getProvider() const { return xRet.get(); }
};

//---------------------------------------------------------------------------------------

extern "C" SAL_DLLPUBLIC_EXPORT void SAL_CALL
component_getImplementationEnvironment(
				const sal_Char	**ppEnvTypeName,
				uno_Environment	** /*ppEnv*/
			)
{
	*ppEnvTypeName = CPPU_CURRENT_LANGUAGE_BINDING_NAME;
}

//---------------------------------------------------------------------------------------
extern "C" SAL_DLLPUBLIC_EXPORT void* SAL_CALL component_getFactory(
					const sal_Char* pImplementationName,
					void* pServiceManager,
					void* /*pRegistryKey*/)
{
	void* pRet = 0;
	if (pServiceManager)
	{
		ProviderRequest aReq(pServiceManager,pImplementationName);

		aReq.CREATE_PROVIDER(
			ODriver::getImplementationName_Static(),
			ODriver::getSupportedServiceNames_Static(),
			ODriver_CreateInstance, ::cppu::createSingleFactory)
		;

		if(aReq.xRet.is())
			aReq.xRet->acquire();

		pRet = aReq.getProvider();
	}

	return pRet;
};


