/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



#ifndef CONNECTIVITY_INDEXHELPER_HXX_
#define CONNECTIVITY_INDEXHELPER_HXX_

#include "connectivity/dbtoolsdllapi.hxx"
#include "connectivity/sdbcx/VIndex.hxx"
#include <com/sun/star/sdbc/XDatabaseMetaData.hpp>

namespace connectivity
{
	class OTableHelper;
	class OOO_DLLPUBLIC_DBTOOLS OIndexHelper : public connectivity::sdbcx::OIndex
	{
		OTableHelper*	m_pTable;
	public:
		virtual void refreshColumns();
	public:
		OIndexHelper(	OTableHelper* _pTable);
		OIndexHelper(	OTableHelper* _pTable,
				const ::rtl::OUString& _Name,
				const ::rtl::OUString& _Catalog,
				sal_Bool _isUnique,
				sal_Bool _isPrimaryKeyIndex,
				sal_Bool _isClustered
			);
		inline OTableHelper* getTable() const { return m_pTable; }
	};
}
#endif // CONNECTIVITY_INDEXHELPER_HXX_

