/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



#ifndef INCLUDED_BINARYURP_SOURCE_PROXY_HXX
#define INCLUDED_BINARYURP_SOURCE_PROXY_HXX

#include "sal/config.h"

#include "boost/noncopyable.hpp"
#include "osl/interlck.h"
#include "rtl/ref.hxx"
#include "rtl/ustring.hxx"
#include "typelib/typedescription.h"
#include "typelib/typedescription.hxx"
#include "uno/any2.h"
#include "uno/dispatcher.h"

namespace binaryurp { class Bridge; }
namespace com { namespace sun { namespace star { namespace uno {
    class UnoInterfaceReference;
} } } }

namespace binaryurp {

class Proxy: public uno_Interface, private boost::noncopyable {
public:
    Proxy(
        rtl::Reference< Bridge > const & bridge, rtl::OUString const & oid,
        com::sun::star::uno::TypeDescription const & type);

    rtl::OUString getOid() const;

    com::sun::star::uno::TypeDescription getType() const;

    void do_acquire();

    void do_release();

    void do_free();

    void do_dispatch(
        typelib_TypeDescription const * member, void * returnValue,
        void ** arguments, uno_Any ** exception) const;

    static bool isProxy(
        rtl::Reference< Bridge > const & bridge,
        com::sun::star::uno::UnoInterfaceReference const & object,
        rtl::OUString * oid);

private:
    ~Proxy();

    void do_dispatch_throw(
        typelib_TypeDescription const * member, void * returnValue,
        void ** arguments, uno_Any ** exception) const;

    bool isProxy(rtl::Reference< Bridge > const & bridge, rtl::OUString * oid)
        const;

    rtl::Reference< Bridge > bridge_;
    rtl::OUString oid_;
    com::sun::star::uno::TypeDescription type_;
    oslInterlockedCount references_;
};

}

#endif
