/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



#include "precompiled_basic.hxx"
#include "comenumwrapper.hxx"

using namespace ::com::sun::star;

::sal_Bool SAL_CALL ComEnumerationWrapper::hasMoreElements()
    throw ( uno::RuntimeException )
{
    sal_Bool bResult = sal_False;

    try
    {
        if ( m_xInvocation.is() )
        {
            sal_Int32 nLength = 0;
            bResult =
                ( ( m_xInvocation->getValue( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "length" ) ) ) >>= nLength )
                  && nLength > m_nCurInd );
        }
    }
    catch( uno::Exception& )
    {}

    return bResult;
}

uno::Any SAL_CALL ComEnumerationWrapper::nextElement()
    throw ( container::NoSuchElementException,
            lang::WrappedTargetException,
            uno::RuntimeException )
{
    try
    {
        if ( m_xInvocation.is() )
        {
            uno::Sequence< sal_Int16 > aNamedParamIndex;
            uno::Sequence< uno::Any > aNamedParam;
            uno::Sequence< uno::Any > aArgs( 1 );

            aArgs[0] <<= m_nCurInd++;

            return m_xInvocation->invoke( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "item" ) ),
                                          aArgs,
                                          aNamedParamIndex,
                                          aNamedParam );
        }
    }
    catch( uno::Exception& )
    {}

    throw container::NoSuchElementException();
}


